/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.Formats;
import org.eaglei.repository.Role;
import org.eaglei.repository.User;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.workflow.WorkflowTransition;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class ImportExport
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ImportExport.class);
    private boolean isImport = false;
    private boolean isExport = false;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.isExport = sc.getInitParameter("export") != null;
        boolean bl = this.isImport = sc.getInitParameter("import") != null;
        if (!this.isExport && !this.isImport) {
            log.error((Object)"Servlet was initialized without either import or export mode set, THIS IS BAD.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mimeType;
        RDFFormat format;
        if (!this.isExport) {
            throw new HttpStatusException(501, "GET is not implemented by this service");
        }
        String rawFormat = null;
        String rawView = null;
        String rawWorkspace = null;
        String rawType = null;
        String include = null;
        String exclude = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("format")) {
                        rawFormat = item.getString();
                        continue;
                    }
                    if (ifn.equals("view")) {
                        rawView = item.getString();
                        continue;
                    }
                    if (ifn.equals("workspace")) {
                        rawWorkspace = item.getString();
                        continue;
                    }
                    if (ifn.equals("type")) {
                        rawType = item.getString();
                        continue;
                    }
                    if (ifn.equals("include")) {
                        include = item.getString();
                        continue;
                    }
                    if (ifn.equals("exclude")) {
                        exclude = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            request.setCharacterEncoding("UTF-8");
            rawFormat = request.getParameter("format");
            rawView = request.getParameter("view");
            rawWorkspace = request.getParameter("workspace");
            rawType = request.getParameter("type");
            include = request.getParameter("include");
            exclude = request.getParameter("exclude");
        }
        TypeArg type = (TypeArg)Utils.parseKeywordArg(TypeArg.class, (String)rawType, (String)"type", (boolean)true, null);
        View view = (View)Utils.parseKeywordArg(View.class, (String)rawView, (String)"view", (boolean)false, null);
        URIImpl workspace = null;
        if (rawWorkspace != null) {
            if (Utils.isValidURI((String)rawWorkspace)) {
                workspace = new URIImpl(rawWorkspace);
            } else {
                throw new BadRequestException("Workspace is not a valid URI: " + rawWorkspace);
            }
        }
        if (workspace != null && view != null) {
            throw new BadRequestException("Only one of the 'workspace' or 'view' args may be specified.");
        }
        if (workspace == null && view == null) {
            view = type == TypeArg.resource ? View.USER_RESOURCES : View.USER;
        }
        Set includes = this.parseXCludeList(include);
        Set excludes = this.parseXCludeList(exclude);
        if (log.isDebugEnabled()) {
            log.debug((Object)("INCLUDES = " + Arrays.deepToString(includes.toArray())));
            log.debug((Object)("EXCLUDES = " + Arrays.deepToString(excludes.toArray())));
        }
        if ((format = Formats.RDFOutputFormatForMIMEType((String)(mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)rawFormat)))) == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mimeType + "\"");
        }
        if (!format.supportsContexts()) {
            throw new HttpStatusException(415, "Format does not support quad (graph) encoding: " + format);
        }
        log.debug((Object)("Output serialization format = " + format));
        if (type == TypeArg.user) {
            if (!Access.isSuperuser((HttpServletRequest)request)) {
                throw new ForbiddenException("Export of users requires administrator privileges.");
            }
            response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
            User.doExportUsers((HttpServletRequest)request, (HttpServletResponse)response, (RDFFormat)format, (Set)includes, (Set)excludes);
        } else if (type == TypeArg.role) {
            if (!Access.isSuperuser((HttpServletRequest)request)) {
                throw new ForbiddenException("Export of roles requires administrator privileges.");
            }
            response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
            Role.doExportRoles((HttpServletRequest)request, (HttpServletResponse)response, (RDFFormat)format, (Set)includes, (Set)excludes);
        } else if (type == TypeArg.transition) {
            if (!Access.isSuperuser((HttpServletRequest)request)) {
                throw new ForbiddenException("Export of roles requires administrator privileges.");
            }
            response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
            WorkflowTransition.doExportTransitions((HttpServletRequest)request, (HttpServletResponse)response, (RDFFormat)format, (Set)includes, (Set)excludes);
        } else if (type == TypeArg.grant) {
            if (!Access.isSuperuser((HttpServletRequest)request)) {
                throw new ForbiddenException("Export of roles requires administrator privileges.");
            }
            response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
            Access.doExportGrants((HttpServletRequest)request, (HttpServletResponse)response, (RDFFormat)format, (Set)includes, (Set)excludes);
        } else {
            throw new HttpStatusException(501, "export of " + type + " not implemented.");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isExport) {
            this.doGet(request, response);
            return;
        }
        if (!this.isImport) {
            throw new HttpStatusException(501, "Servlet must be configured for import or export.");
        }
        String rawFormat = null;
        String rawDuplicate = null;
        String rawTransform = null;
        String rawIgnoreACL = null;
        String rawNewGraph = null;
        String rawType = null;
        String include = null;
        String exclude = null;
        String contentType = null;
        InputStream contentStream = null;
        Reader content = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("format")) {
                        rawFormat = item.getString();
                        continue;
                    }
                    if (ifn.equals("duplicate")) {
                        rawDuplicate = item.getString();
                        continue;
                    }
                    if (ifn.equals("transform")) {
                        rawTransform = item.getString();
                        continue;
                    }
                    if (ifn.equals("ignoreACL")) {
                        rawIgnoreACL = item.getString();
                        continue;
                    }
                    if (ifn.equals("newgraph")) {
                        rawNewGraph = item.getString();
                        continue;
                    }
                    if (ifn.equals("type")) {
                        rawType = item.getString();
                        continue;
                    }
                    if (ifn.equals("include")) {
                        include = item.getString();
                        continue;
                    }
                    if (ifn.equals("exclude")) {
                        exclude = item.getString();
                        continue;
                    }
                    if (ifn.equals("content")) {
                        contentStream = item.getInputStream();
                        contentType = item.getContentType();
                        log.debug((Object)("Got content stream, MIME type = " + contentType));
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            request.setCharacterEncoding("UTF-8");
            rawFormat = request.getParameter("format");
            rawDuplicate = request.getParameter("duplicate");
            rawTransform = request.getParameter("transform");
            rawIgnoreACL = request.getParameter("ignoreACL");
            rawNewGraph = request.getParameter("newgraph");
            rawType = request.getParameter("type");
            include = request.getParameter("include");
            exclude = request.getParameter("exclude");
            String cs = request.getParameter("content");
            if (cs != null) {
                content = new StringReader(cs);
            }
        }
        TypeArg type = (TypeArg)Utils.parseKeywordArg(TypeArg.class, (String)rawType, (String)"type", (boolean)true, null);
        DuplicateArg duplicate = (DuplicateArg)Utils.parseKeywordArg(DuplicateArg.class, (String)rawDuplicate, (String)"duplicate", (boolean)false, (Enum)DuplicateArg.abort);
        NewGraphArg newGraph = (NewGraphArg)Utils.parseKeywordArg(NewGraphArg.class, (String)rawNewGraph, (String)"newgraph", (boolean)false, (Enum)NewGraphArg.abort);
        boolean transform = Utils.parseBooleanParameter((String)rawTransform, (String)"transform", (boolean)true, (boolean)false);
        boolean ignoreACL = Utils.parseBooleanParameter((String)rawIgnoreACL, (String)"ignoreACL", (boolean)false, (boolean)false);
        Set includes = this.parseXCludeList(include);
        Set excludes = this.parseXCludeList(exclude);
        if (rawFormat == null) {
            rawFormat = contentType;
        }
        if (rawFormat == null) {
            throw new BadRequestException("Missing required argument: format (or content-type on input)");
        }
        if (contentStream != null) {
            try {
                String csn = Utils.contentTypeGetCharset((String)rawFormat, (String)"UTF-8");
                log.debug((Object)("Reading serialized RDF from stream with charset=" + csn));
                content = new InputStreamReader(contentStream, Charset.forName(csn));
            }
            catch (IllegalCharsetNameException e) {
                throw new BadRequestException("Illegal character set name in content-type spec: " + e);
            }
            catch (UnsupportedCharsetException e) {
                throw new BadRequestException("Unsupported character set name in content-type spec: " + e);
            }
        } else if (content == null) {
            throw new BadRequestException("Missing the required content argument.");
        }
        String mime = Utils.contentTypeGetMIMEType((String)rawFormat);
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mime);
        if (format == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mime + "\"");
        }
        if (!format.supportsContexts()) {
            throw new HttpStatusException(415, "Format does not support quad (graph) encoding: " + format);
        }
        log.debug((Object)("Input serialization format = " + format));
        SailRepository mr = null;
        RepositoryConnection mrc = null;
        try {
            mr = new SailRepository((Sail)new MemoryStore());
            mr.initialize();
            mrc = mr.getConnection();
            mrc.add(content, "", format, new Resource[0]);
            if (type == TypeArg.user) {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This request requires administrator privileges.");
                }
                User.doImportUsers((HttpServletRequest)request, (HttpServletResponse)response, (RepositoryConnection)mrc, (Set)includes, (Set)excludes, (DuplicateArg)duplicate, (boolean)transform);
            } else if (type == TypeArg.role) {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This request requires administrator privileges.");
                }
                Role.doImportRoles((HttpServletRequest)request, (HttpServletResponse)response, (RepositoryConnection)mrc, (Set)includes, (Set)excludes, (DuplicateArg)duplicate, (boolean)transform);
            } else if (type == TypeArg.transition) {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This request requires administrator privileges.");
                }
                WorkflowTransition.doImportTransitions((HttpServletRequest)request, (HttpServletResponse)response, (RepositoryConnection)mrc, (Set)includes, (Set)excludes, (DuplicateArg)duplicate, (boolean)transform, (boolean)ignoreACL);
            } else if (type == TypeArg.grant) {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This request requires administrator privileges.");
                }
                Access.doImportGrants((HttpServletRequest)request, (HttpServletResponse)response, (RepositoryConnection)mrc, (Set)includes, (Set)excludes, (DuplicateArg)duplicate, (boolean)transform, (boolean)ignoreACL);
            } else {
                throw new HttpStatusException(501, "import of " + type + " not implemented.");
            }
            WithRepositoryConnection.get((ServletRequest)request).commit();
        }
        catch (OpenRDFException e) {
            log.error((Object)"Failed loading import content or calling import: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (mrc != null && mrc.isOpen()) {
                    mrc.close();
                }
                if (mr != null) {
                    mr.shutDown();
                }
            }
            catch (RepositoryException e) {
                log.error((Object)"Failed while closing temporary repo of import content: ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private Set<String> parseXCludeList(String s) {
        HashSet<String> result = new HashSet<String>();
        if (s != null) {
            for (String e : s.split("\\s*,\\s*")) {
                result.add(e);
            }
        }
        return result;
    }
}

