/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.ErrorSendingException;
import org.openrdf.repository.RepositoryException;

public class RepositoryServlet
extends HttpServlet {
    private static Logger log = LogManager.getLogger(RepositoryServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqURI = req.getRequestURI();
        try {
            log.debug((Object)("============== Starting Request " + reqURI));
            super.service(req, resp);
        }
        catch (ErrorSendingException e) {
            try {
                WithRepositoryConnection.get((ServletRequest)req).rollback();
            }
            catch (RepositoryException re) {
                log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
            }
            try {
                resp.sendError(e.getStatus(), e.getMessage());
            }
            catch (IllegalStateException ie) {
                log.error((Object)("Cannot convert Status Exception to appropriate status because response is in wrong state.  Original exception=" + e.toString()), (Throwable)ie);
            }
        }
        finally {
            log.debug((Object)("============== Ending Request " + reqURI));
        }
    }
}

