/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.Role;
import org.eaglei.repository.User;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.impl.MapBindingSet;

public class WhoAmI
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WhoAmI.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        if (request.getParameter("create") != null) {
            throw new BadRequestException("'create' arg is only allowed with POST method");
        }
        this.whoami(request, response, request.getParameter("format"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rawcreate = null;
        String firstName = null;
        String lastName = null;
        String mbox = null;
        String format = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("create")) {
                        rawcreate = item.getString();
                        continue;
                    }
                    if (ifn.equals("firstname")) {
                        firstName = item.getString();
                        continue;
                    }
                    if (ifn.equals("lastname")) {
                        lastName = item.getString();
                        continue;
                    }
                    if (ifn.equals("mbox")) {
                        mbox = item.getString();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            request.setCharacterEncoding("UTF-8");
            rawcreate = request.getParameter("create");
            firstName = request.getParameter("firstname");
            lastName = request.getParameter("lastname");
            mbox = request.getParameter("mbox");
            format = request.getParameter("format");
        }
        boolean create = Utils.parseBooleanParameter((String)rawcreate, (String)"create", (boolean)false, (boolean)false);
        if (create) {
            String login = Access.getAuthenticatedUsername((HttpServletRequest)request);
            User u = Access.getPrincipalUser((HttpServletRequest)request);
            if (login == null) {
                throw new BadRequestException("No authentication found.");
            }
            if (u != null) throw new ConflictException("There is already User metadata for login name = " + login);
            u = User.createAsAdministrator((HttpServletRequest)request, (String)login);
            if (Access.isSuperuser((HttpServletRequest)request)) {
                u.addRoleAsAdministrator(request, Role.find((HttpServletRequest)request, (URI)REPO.ROLE_SUPERUSER));
            }
            if (firstName != null) {
                u.setFirstName(request, firstName);
            }
            if (lastName != null) {
                u.setLastName(request, lastName);
            }
            if (mbox != null) {
                u.setMbox(request, mbox);
            }
            u.update(request);
            response.setStatus(201);
            return;
        } else {
            this.whoami(request, response, format);
        }
    }

    private void whoami(HttpServletRequest request, HttpServletResponse response, String format) throws ServletException, IOException {
        ArrayList<MapBindingSet> result = new ArrayList<MapBindingSet>();
        MapBindingSet nbs = new MapBindingSet(6);
        User u = Access.getPrincipalUser((HttpServletRequest)request);
        log.debug((Object)("authenticated User = " + u));
        if (u == null) {
            nbs.addBinding("uri", (Value)Access.getPrincipalURI((HttpServletRequest)request));
            nbs.addBinding("username", null);
            nbs.addBinding("firstname", null);
            nbs.addBinding("lastname", null);
            nbs.addBinding("mbox", null);
        } else {
            nbs.addBinding("uri", (Value)u.getURI());
            nbs.addBinding("username", (Value)new LiteralImpl(u.getUsername()));
            nbs.addBinding("firstname", (Value)(u.getFirstName() == null ? null : new LiteralImpl(u.getFirstName())));
            nbs.addBinding("lastname", (Value)(u.getLastName() == null ? null : new LiteralImpl(u.getLastName())));
            nbs.addBinding("mbox", (Value)(u.getMbox() == null ? null : new LiteralImpl(u.getMbox())));
        }
        nbs.addBinding("isSuperuser", (Value)(Access.isSuperuser((HttpServletRequest)request) ? BooleanLiteralImpl.TRUE : BooleanLiteralImpl.FALSE));
        result.add(nbs);
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
    }
}

