/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.workflow.Workflow;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;

public class WorkflowPush
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowPush.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String rawURI = null;
        String rawTransition = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                File tmp = (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir");
                if (tmp == null) {
                    throw new InternalServerErrorException("Cannot find servlet context attr = \"javax.servlet.context.tempdir\"");
                }
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, tmp));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("transition")) {
                        rawTransition = item.getString();
                        continue;
                    }
                    if (ifn.equals("uri")) {
                        rawURI = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            rawTransition = request.getParameter("transition");
            rawURI = request.getParameter("uri");
        }
        URI uri = Utils.parseURI((String)rawURI, (String)"uri", (boolean)true);
        URI transURI = Utils.parseURI((String)rawTransition, (String)"transition", (boolean)true);
        Workflow wf = Workflow.find((HttpServletRequest)request, (URI)uri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PUSH PARAMETERS:\nresource=" + uri + "\ntransition=" + transURI));
        }
        wf.invokeTransition(request, transURI);
        try {
            WithRepositoryConnection.get((ServletRequest)request).commit();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

