/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.workflow;

import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.workflow.WorkflowAction;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;

public class ActionMoveGraph
implements WorkflowAction {
    private static Logger log = LogManager.getLogger(ActionMoveGraph.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransition(HttpServletRequest request, URI resource, Value param) throws Exception {
        if (param == null || !(param instanceof URI)) {
            throw new BadRequestException("ActionMoveGraph requires a valid URI parameter, naming the destination graph.");
        }
        URI newGraph = (URI)param;
        Object homeGraph = null;
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        RepositoryResult rr = null;
        try {
            rr = rc.getStatements((Resource)resource, RDF.TYPE, null, false, new Resource[0]);
            while (rr.hasNext()) {
                Statement s = (Statement)rr.next();
                Resource ctx = s.getContext();
                log.debug((Object)("Found statement: " + resource + " rdf:type " + s.getObject() + ", in graph " + ctx));
                if (!(ctx instanceof URI)) continue;
                homeGraph = (URI)ctx;
                break;
            }
        }
        finally {
            rr.close();
        }
        if (homeGraph == null) {
            log.error((Object)("Failed to find home graph for resource instance=" + resource));
            throw new InternalServerErrorException("Failed to find home graph for resource instance=" + resource);
        }
        if (homeGraph.equals(newGraph)) {
            log.warn((Object)("Tried to move resource inst=" + resource + " to the same named graph: " + homeGraph));
            return;
        }
        List stms = null;
        try {
            rr = rc.getStatements((Resource)resource, null, null, false, new Resource[]{homeGraph});
            stms = rr.asList();
        }
        finally {
            rr.close();
        }
        for (Statement s : stms) {
            rc.remove(s, new Resource[]{homeGraph});
            rc.add(s, new Resource[]{newGraph});
        }
    }
}

