<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   - Data Repository Admin UI: Edit Access Control (ACLs) on *any* object
   -
   - This page both presents ACLs and executes a request to edit the ACL.
   -
   -  REQUIRED ARGS:
   -   uri = uri of the object
   -  RECOMMENDED args:
   -   type = object type name to display (precision doesn't matter)
   -   label= label for the instance URI
   -   backLink, backLabel = link URL and text for "return" link
   -  ONLY REQUIRED WHEN CHANGING ACL:
   -   action= (add, remove)
   -   agent=uri of agent (user or role)
   -   access=uri of access property
   -
   -   lock_access=uri - lock the selected value of access to this URI..
   -
   -  Larry Stone  - started May 2010
  --%>
<%@ page import="javax.servlet.http.HttpServletResponse" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.openrdf.model.ValueFactory" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.AccessGrant" %>
<%@ page import="org.eaglei.repository.Role" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.vocabulary.REPO" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>

<%! private static Logger log = LogManager.getLogger("org.eaglei.repository.admin.namedGraphs.jsp"); %>

  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository Admin - Edit Access Control List</title>
  </head>
<%
    try {
%>
  <body>
<%
    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = false;

    // sanity-check args
    String rawuri = request.getParameter("uri");
    if (rawuri == null) {
        response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'uri'");
        return;
    }
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    ValueFactory vf = rc.getValueFactory();
    URI uri = null;
    try {
        uri = vf.createURI(rawuri);
    } catch (IllegalArgumentException e) {
        response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI: "+e);
        return;
    }
    String type = request.getParameter("type");
    if (type == null)
        type = "Unknown-type";

    // if action given, try to do the add or remove..
    // sanity check args first:
    String action = request.getParameter("action");
    String access = request.getParameter("access");
    URI lock_access = Utils.parseURI(request.getParameter("lock_access"), "lock_access", false);
    String agents[] = request.getParameterValues("agent");
    if (action != null) {
        String agent = null;
        for (String a : agents) {
            if (a.length() > 0) {
                if (agent != null) {
                    response.sendError(HttpServletResponse.SC_BAD_REQUEST,
                      "There may not be more than one value for agent: "+agent+", and: "+a);
                    return;
                } else
                    agent = a;
            }
        }
        if (agent == null || agent.length() == 0 || access == null || access.length() == 0) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST,  "Request is missing one of the required arguments, 'agent' or 'access'.");
            return;
        }
        try {
            URI agentURI = vf.createURI(agent);
            URI accessURI = vf.createURI(access);
            if (action.equals("add")) {
                Access.addGrant(request, uri, agentURI, accessURI);
                messageSuccess = true;
                message = "New grant has been added.";
            } else if (action.equals("remove")) {
                messageSuccess = Access.removeGrant(request, uri, agentURI, accessURI);
                message = messageSuccess ? "Grant has been removed." : "Specified grant was not found.";
            } else {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST,  "Unrecognized value of 'action': "+action);
                return;
            }
            // need to save changes to the triplestore.
            rc.commit();
        } catch (IllegalArgumentException e) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI: "+e);
            return;
        }
    }

    // need these later
    String backLink = request.getParameter("backLink");
    if (backLink == null)
        backLink = request.getHeader("Referer");  // "sic"
    String backLabel = request.getParameter("backLabel");
%>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Edit Access to a <%= StringEscapeUtils.escapeHtml(type) %></h2>
    <h3><% String ulabel = request.getParameter("label");
         if (ulabel != null)
            out.write("Name: "+StringEscapeUtils.escapeHtml(ulabel)); %>
        <br>URI: <code>&nbsp;<%= StringEscapeUtils.escapeHtml(uri.toString()) %></code>
    </h3>

<%
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

   <h2>Current Access Grants:</h2>
    <table border="1">
      <tr><th>Agent</th><th>Access Type</th><th>Delete</th></tr>
<%
    for (AccessGrant g : Access.getGrants(request, uri)) {
%>
      <tr>
        <td>
        <%= StringEscapeUtils.escapeHtml(g.agent.label) %>
        [<%= StringEscapeUtils.escapeHtml(g.agentType.label) %>]
        </td>
        <td><%= StringEscapeUtils.escapeHtml(g.access.label) %></td>
        <td>
<%  if (g.builtin) { %>
          <i>Built-In</i>
<%  } else { %>
          <form accept-charset="UTF-8" method="post" action="" style="margin: 0pt;">
<%      if (backLink != null) { %>
          <input type="hidden" name="backLink" value="<%= Utils.escapeHTMLAttribute( backLink) %>"/>
<%      } %>
<%  if (backLabel != null) { %>
          <input type="hidden" name="backLabel" value="<%= Utils.escapeHTMLAttribute( backLabel) %>"/>
<%      } %>
          <input type="hidden" name="type" value="<%= Utils.escapeHTMLAttribute( type) %>"/>
          <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute( uri.toString()) %>"/>
          <input type="hidden" name="action" value="remove"/>
          <input type="hidden" name="agent" value="<%= Utils.escapeHTMLAttribute( g.agent.toString()) %>"/>
          <input type="hidden" name="access" value="<%= Utils.escapeHTMLAttribute( g.access.toString()) %>"/>
<%  if (lock_access != null) { %>
          <input type="hidden" name="lock_access" value="<%= Utils.escapeHTMLAttribute(lock_access.stringValue()) %>"/>
<%      } %>
          <button type="submit">Delete!</button>
          </form>
<%  } %>
        </td>
      </tr>
<%
    }
%>
    </table>

  <h2>Add New Access Grant:</h2>

   <form accept-charset="UTF-8" method="post" action="">
<%  if (backLink != null) { %>
    <input type="hidden" name="backLink" value="<%= Utils.escapeHTMLAttribute( backLink) %>"/>
<%  } %>
<%  if (backLabel != null) { %>
    <input type="hidden" name="backLabel" value="<%= Utils.escapeHTMLAttribute( backLabel) %>"/>
<%  } %>
    <input type="hidden" name="type" value="<%= Utils.escapeHTMLAttribute( type) %>"/>
    <input type="hidden" name="action" value="add"/>
    <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute( uri.toString()) %>"/>
<%  if (lock_access != null) { %>
          <input type="hidden" name="lock_access" value="<%= Utils.escapeHTMLAttribute(lock_access.stringValue()) %>"/>
<%      } %>
   <div style="width: 50%;">
    <fieldset style="width: 80%; align: center;">
     <legend><b>Choose Agent to have Access</b></legend>
       <font size="-1"><i>Select EITHER a user OR role:</i></font><br/>
       <b>User:</b>
       <select name="agent">
         <option value="">--none--</option>
<%
    for (User u : User.findAll(request)) {
%>
            <option value="<%= Utils.escapeHTMLAttribute( u.getURI().stringValue()) %>"><%= StringEscapeUtils.escapeHtml(u.getTitle()) %></option>
<%
    }
%>
       </select>
       <br>&nbsp;&nbsp;&nbsp;<b>-- or --</b>
       <br>
       <b>Role:</b>
       <select name="agent">
         <option value="">--none--</option>
<%
    for (Role r : Role.findAllGrantable(request)) {
%>
            <option value="<%= Utils.escapeHTMLAttribute( r.getURI().stringValue()) %>"><%= StringEscapeUtils.escapeHtml(r.getLabel()) %></option>
<%
    }
%>
          </select>
    </fieldset>
    <p>

   <b>Access Type:</b>
         <select name="access">
           <option value="" <%= lock_access == null ? "" : "disabled" %>>--none--</option>
<%
    for (Access a : Access.values()) {
        URI aURI = a.getURI();
%>
           <option value="<%= Utils.escapeHTMLAttribute( aURI.stringValue()) %>"
             <%= lock_access == null ? "" : (aURI.equals(lock_access) ? "selected" : "disabled") %>>
             <%= StringEscapeUtils.escapeHtml(a.toString()) %>
           </option>
<%
    }
%>
         </select>
    <p>
    <div width="50%" align="center">
      <button type="reset">Reset Form</button>
      &nbsp;&nbsp;&nbsp;&nbsp;
      <button name="submit" value="submit" type="submit">Add!</button>
    </div>
   </div>

   </form>
<%
    if (backLink != null) {
        if (backLabel == null)
            backLabel = "Back to previous page";
%>
    <br/>
    <br/>
    <a href="<%= Utils.escapeHTMLAttribute( backLink) %>"><%= StringEscapeUtils.escapeHtml(backLabel) %></a>
<%      } %>
    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    // This is the idiom that much of the repo code uses to pass
    // HTTP status results back as a RuntimeException subclass..
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
