/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class NamedGraph
implements Comparable<NamedGraph> {
    private static Logger log = LogManager.getLogger(NamedGraph.class);
    private static final String R_NG_MAP = "org.eaglei.repository.NamedGraph.Map";
    private static final String R_NG_ALL = "org.eaglei.repository.NamedGraph.All";
    private URI name;
    private String label;
    private Type type;
    private String typeLabel;
    private boolean anonAccess;
    private boolean hasMetadata = false;
    private boolean dirty = false;
    private static final String ngQuery = "SELECT DISTINCT * WHERE { ?namedGraphURI a <" + REPO.NAMED_GRAPH + "> . \n" + " OPTIONAL { ?namedGraphURI <" + RDFS.LABEL + "> ?namedGraphLabel } \n" + " OPTIONAL { ?namedGraphURI <" + REPO.NG_TYPE + "> ?typeURI . " + " ?typeURI <" + RDFS.LABEL + "> ?typeLabel } \n" + " OPTIONAL { ?namedGraphURI <" + REPO.HAS_READ_ACCESS + "> ?anon \n" + "            FILTER( ?anon = <" + REPO.ROLE_ANONYMOUS + "> )}}";

    private NamedGraph(URI name, String label, URI type, String typeLabel, boolean anonAccess) {
        this.name = name;
        this.label = label;
        this.type = Type.parse((URI)type);
        this.typeLabel = typeLabel;
        this.anonAccess = anonAccess;
        this.hasMetadata = true;
    }

    private NamedGraph(URI name) {
        this.name = name;
        this.hasMetadata = false;
    }

    public static List<NamedGraph> findAll(HttpServletRequest request) throws ServletException {
        return new ArrayList<NamedGraph>(NamedGraph.findInternal((HttpServletRequest)request, null).values());
    }

    public static NamedGraph find(HttpServletRequest request, URI name) throws ServletException {
        return NamedGraph.find((HttpServletRequest)request, (URI)name, (boolean)false);
    }

    public static NamedGraph find(HttpServletRequest request, URI name, boolean createp) throws ServletException {
        Map ngs = NamedGraph.findInternal((HttpServletRequest)request, (URI)name);
        NamedGraph result = (NamedGraph)ngs.get(name);
        if (result == null) {
            if (createp) {
                result = new NamedGraph(name);
            } else {
                log.warn((Object)("Failed to find named graph or context for name=" + name));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URI, NamedGraph> findInternal(HttpServletRequest request, URI name) throws ServletException {
        HashMap<URI, NamedGraph> result = (HashMap<URI, NamedGraph>)request.getAttribute("org.eaglei.repository.NamedGraph.Map");
        if (result != null && (name == null && request.getAttribute("org.eaglei.repository.NamedGraph.All") != null || name != null && result.containsKey(name))) {
            return result;
        }
        if (result == null) {
            result = new HashMap<URI, NamedGraph>();
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NamedGraph SPARQL query = " + ngQuery));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, ngQuery);
            if (name != null) {
                q.setBinding("namedGraphURI", (Value)name);
            }
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(true);
            q.evaluate((TupleQueryResultHandler)new graphHandler(result, name));
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        if (name == null || !result.containsKey(name)) {
            try {
                RepositoryResult rr = null;
                try {
                    rr = rc.getContextIDs();
                    while (rr.hasNext()) {
                        Resource ctx = (Resource)rr.next();
                        if (!(ctx instanceof URI) || name != null && !name.equals((URI)ctx) || result.containsKey((URI)ctx)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found 'undocumented' named graph (context), name=" + ctx));
                        }
                        result.put((URI)ctx, new NamedGraph((URI)ctx));
                    }
                }
                finally {
                    rr.close();
                }
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
        }
        request.setAttribute("org.eaglei.repository.NamedGraph.Map", result);
        if (name == null) {
            request.setAttribute("org.eaglei.repository.NamedGraph.All", (Object)Boolean.TRUE);
        }
        return result;
    }

    public URI getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.name.getLocalName();
    }

    public Type getType() {
        return this.type;
    }

    public URI getTypeURI() {
        return this.type == null ? null : Type.access$000((Type)this.type);
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public boolean isAnonymousReadable() {
        return this.anonAccess;
    }

    public boolean isManaged() {
        return this.hasMetadata;
    }

    public void setLabel(HttpServletRequest request, String nl) throws ServletException {
        this.setMetadataInternal(request, RDFS.LABEL, (Value)new LiteralImpl(nl, XMLSchema.STRING));
        this.label = nl;
    }

    public void setType(HttpServletRequest request, URI nt) throws ServletException {
        Type ntt = Type.parse((URI)nt);
        if (ntt != null) {
            this.setType(request, ntt);
        }
    }

    public void setType(HttpServletRequest request, Type nt) throws ServletException {
        this.setMetadataInternal(request, REPO.NG_TYPE, (Value)Type.access$000((Type)nt));
        this.type = nt;
        this.typeLabel = Type.access$000((Type)nt).getLocalName();
    }

    public void commit(HttpServletRequest request) throws ServletException {
        try {
            if (this.dirty) {
                WithRepositoryConnection.get((ServletRequest)request).commit();
            }
        }
        catch (OpenRDFException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, Value newVal) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            boolean hasType = rc.hasStatement((Resource)this.name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, false, new Resource[]{REPO.NG_INTERNAL});
            if (hasType && rc.hasStatement((Resource)this.name, property, newVal, false, new Resource[]{REPO.NG_INTERNAL})) {
                log.debug((Object)("Nothing to set, graph=" + this.name + " already has " + property + " = " + newVal));
            } else {
                if (!hasType) {
                    rc.add((Resource)this.name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, new Resource[]{REPO.NG_INTERNAL});
                    this.hasMetadata = true;
                }
                rc.remove((Resource)this.name, property, null, new Resource[]{REPO.NG_INTERNAL});
                rc.add((Resource)this.name, property, newVal, new Resource[]{REPO.NG_INTERNAL});
                this.dirty = true;
                log.debug((Object)("Setting graph=" + this.name + ",  " + property + " = " + newVal));
            }
        }
        catch (OpenRDFException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean equals(Object b) {
        return b instanceof NamedGraph && ((NamedGraph)b).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(NamedGraph o) {
        return this.name.toString().compareTo(o.name.toString());
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

