/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.workflow;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.User;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.HandlerBadRequest;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.eaglei.repository.workflow.WorkflowAction;
import org.eaglei.repository.workflow.WorkflowTransition;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkflowTransition {
    private static Logger log = LogManager.getLogger(WorkflowTransition.class);
    private URI uri;
    private String label = null;
    private String comment = null;
    private URI workspace = null;
    private URI initialState = null;
    private URI finalState = null;
    private WorkflowAction action = null;
    private Value actionParameter = null;
    private Literal order = null;
    private String workspaceLabel = null;
    private String initialLabel = null;
    private String finalLabel = null;
    private boolean dirty = false;
    private static final String transitionQueryPrefix = "{?uri a <" + REPO.WORKFLOW_TRANSITION + "> ; \n" + " <" + RDFS.LABEL + "> ?label ;\n" + " <" + REPO.INITIAL + "> ?initial; \n" + " <" + REPO.FINAL + "> ?final. \n" + " OPTIONAL { ?uri <" + REPO.ACTION + "> ?action . \n" + "   OPTIONAL { ?uri <" + REPO.ACTION_PARAMETER + "> ?actionParameter }} \n" + " OPTIONAL { ?uri <" + RDFS.COMMENT + "> ?comment }\n" + " OPTIONAL { ?uri <" + REPO.WORKSPACE + "> ?workspace \n" + "   OPTIONAL { ?workspace <" + RDFS.LABEL + "> ?workspaceLabel }}\n" + " OPTIONAL { ?initial <" + RDFS.LABEL + "> ?initialLabel }\n" + " OPTIONAL { ?final <" + RDFS.LABEL + "> ?finalLabel }\n" + " OPTIONAL { ?uri <" + REPO.ORDER + "> ?order } \n";
    private static final String transitionQuerySuffix = "ORDER BY ?order ?label";

    private WorkflowTransition(URI uri, String label, String comment, URI initialState, URI finalState) {
        this.uri = uri;
        this.label = label;
        this.comment = comment;
        this.initialState = initialState;
        this.finalState = finalState;
    }

    public static WorkflowTransition find(HttpServletRequest request, URI uri) throws ServletException {
        List result = (List)WorkflowTransition.findAccessibleByAttributes((HttpServletRequest)request, (URI)uri, null, null, null);
        if (result.isEmpty()) {
            throw new NotFoundException("There is no Transition of URI=" + uri);
        }
        return (WorkflowTransition)result.get(0);
    }

    public static Collection<WorkflowTransition> findAll(HttpServletRequest request) throws ServletException {
        return WorkflowTransition.findAccessibleByAttributes((HttpServletRequest)request, null, null, null, null);
    }

    public static Collection<WorkflowTransition> findAccessibleByAttributes(HttpServletRequest request, URI single, URI initialStateMatch, URI workspaceMatch, URI accessible) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            StringBuilder qb = new StringBuilder(transitionQueryPrefix);
            if (workspaceMatch != null) {
                qb.append(" FILTER (!BOUND(?workspace) || ?workspace = <").append(workspaceMatch).append(">)\n");
            }
            qb.append("}");
            transitionHandler hdl = new transitionHandler();
            boolean superuser = false;
            if (accessible != null) {
                if (REPO.ROLE_SUPERUSER.equals(accessible)) {
                    superuser = true;
                } else {
                    User au = User.find((HttpServletRequest)request, (URI)accessible);
                    boolean bl = superuser = au != null && au.isSuperuser();
                }
                if (superuser) {
                    log.debug((Object)"findAccessibleByAttr: Eliding filter because accessor is superuser");
                }
            }
            if (accessible == null || superuser) {
                qb.insert(0, "SELECT DISTINCT * WHERE ");
                qb.append("ORDER BY ?order ?label");
                String qs = qb.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Transition FIND SPARQL query (?uri=" + single + ", ?initial=" + initialStateMatch + "), query= " + qs));
                }
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
                q.clearBindings();
                if (single != null) {
                    q.setBinding("uri", (Value)single);
                }
                if (initialStateMatch != null) {
                    q.setBinding("initial", (Value)initialStateMatch);
                }
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.setIncludeInferred(false);
                q.evaluate((TupleQueryResultHandler)hdl);
            } else {
                MapBindingSet bs = new MapBindingSet(2);
                if (single != null) {
                    bs.addBinding("uri", (Value)single);
                }
                if (initialStateMatch != null) {
                    bs.addBinding("initial", (Value)initialStateMatch);
                }
                Access.filterByPermission((HttpServletRequest)request, (URI)accessible, (String)"uri", (String)" * ", (String)qb.toString(), (Access)Access.READ, (Dataset)SPARQL.InternalGraphs, (BindingSet)bs, (TupleQueryResultHandler)hdl);
            }
            log.debug((Object)("findAccessibleByAttributes: Got result count=" + String.valueOf(transitionHandler.access$000((transitionHandler)hdl).size())));
            return transitionHandler.access$000((transitionHandler)hdl);
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLabel() {
        return this.label == null ? this.uri.stringValue() : this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getWorkspace() {
        return this.workspace;
    }

    public String getWorkspaceLabel() {
        return this.workspaceLabel;
    }

    public URI getInitial() {
        return this.initialState;
    }

    public String getInitialLabel() {
        return this.initialLabel;
    }

    public URI getFinal() {
        return this.finalState;
    }

    public String getFinalLabel() {
        return this.finalLabel;
    }

    public String getOrder() {
        return this.order == null ? null : this.order.stringValue();
    }

    public WorkflowAction getAction() {
        return this.action;
    }

    public Value getActionParameter() {
        return this.actionParameter;
    }

    public static WorkflowTransition create(HttpServletRequest request, URI prefURI, String label, String comment, URI initialState, URI finalState) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to create a new Transition.");
        }
        if (label == null || label.trim().length() == 0) {
            throw new BadRequestException("Label is required when creating a new Transition.");
        }
        if (initialState == null || finalState == null) {
            throw new BadRequestException("Initial and Final WorkflowStates are required when creating a new Transition.");
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        URI subject = prefURI != null ? prefURI : vf.createURI(DataRepository.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
        WorkflowTransition result = new WorkflowTransition(subject, label, comment, initialState, finalState);
        log.debug((Object)("Created new transition: " + result));
        result.dirty = true;
        result.write(request, false);
        return result;
    }

    private URI write(HttpServletRequest request, boolean makeURI) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            if (makeURI) {
                this.uri = vf.createURI(DataRepository.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
            }
            log.debug((Object)("Writing to RDF database: " + this));
            rc.add((Resource)this.uri, RDF.TYPE, (Value)REPO.WORKFLOW_TRANSITION, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)this.uri, RDFS.LABEL, (Value)vf.createLiteral(this.label), new Resource[]{REPO.NG_INTERNAL});
            if (this.comment != null) {
                rc.add((Resource)this.uri, RDFS.COMMENT, (Value)vf.createLiteral(this.comment), new Resource[]{REPO.NG_INTERNAL});
            }
            rc.add((Resource)this.uri, REPO.INITIAL, (Value)this.initialState, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)this.uri, REPO.FINAL, (Value)this.finalState, new Resource[]{REPO.NG_INTERNAL});
            if (this.workspace != null) {
                rc.add((Resource)this.uri, REPO.WORKSPACE, (Value)this.workspace, new Resource[]{REPO.NG_INTERNAL});
            }
            if (this.action != null) {
                rc.add((Resource)this.uri, REPO.ACTION, (Value)vf.createLiteral(this.action.getClass().getName()), new Resource[]{REPO.NG_INTERNAL});
            }
            if (this.actionParameter != null) {
                rc.add((Resource)this.uri, REPO.ACTION_PARAMETER, this.actionParameter, new Resource[]{REPO.NG_INTERNAL});
            }
            if (this.order != null) {
                rc.add((Resource)this.uri, REPO.ORDER, (Value)this.order, new Resource[]{REPO.NG_INTERNAL});
            }
            return this.uri;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void delete(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to delete a Transition.");
        }
        log.debug((Object)("Deleting: " + this));
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
            this.dirty = true;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setLabel(HttpServletRequest request, String val) throws ServletException {
        if (val == null || val.length() == 0) {
            throw new BadRequestException("Label must be a non-empty string.");
        }
        this.label = val;
        this.setMetadataInternal(request, RDFS.LABEL, (Value)new LiteralImpl(val));
    }

    public void setComment(HttpServletRequest request, String val) throws ServletException {
        this.comment = val;
        this.setMetadataInternal(request, RDFS.COMMENT, (Value)(val == null ? null : new LiteralImpl(val)));
    }

    public void setWorkspace(HttpServletRequest request, URI val) throws ServletException {
        this.workspace = val;
        this.setMetadataInternal(request, REPO.WORKSPACE, (Value)val);
    }

    public void setInitial(HttpServletRequest request, URI val) throws ServletException {
        if (val == null) {
            throw new BadRequestException("New state value may not be null");
        }
        this.initialState = val;
        this.setMetadataInternal(request, REPO.INITIAL, (Value)val);
    }

    public void setFinal(HttpServletRequest request, URI val) throws ServletException {
        if (val == null) {
            throw new BadRequestException("New state value may not be null");
        }
        this.finalState = val;
        this.setMetadataInternal(request, REPO.FINAL, (Value)val);
    }

    public void setOrder(HttpServletRequest request, String val) throws ServletException {
        NumericLiteralImpl litVal;
        block3: {
            litVal = null;
            try {
                if (val != null) {
                    litVal = new NumericLiteralImpl((Number)Integer.decode(val), XMLSchema.INTEGER);
                }
            }
            catch (NumberFormatException e) {
                log.debug((Object)("setOrder: got non-integer value = \"" + val + "\""));
                if (val == null) break block3;
                litVal = new LiteralImpl(val);
            }
        }
        this.order = litVal;
        this.setMetadataInternal(request, REPO.ORDER, (Value)litVal);
    }

    public void setAction(HttpServletRequest request, String val) throws ServletException {
        if (val != null) {
            try {
                Object newAction = Class.forName(val).newInstance();
                if (!(newAction instanceof WorkflowAction)) {
                    throw new BadRequestException("Action class does not implement WorkflowAction: " + val);
                }
                this.action = (WorkflowAction)newAction;
            }
            catch (Exception e) {
                throw new BadRequestException("Failed to instantiate Action class: " + val + ": " + e);
            }
        }
        this.setMetadataInternal(request, REPO.ACTION, (Value)(val == null ? null : new LiteralImpl(val)));
    }

    public void setActionParameter(HttpServletRequest request, String str) throws ServletException {
        Object val = null;
        if (str != null) {
            val = Utils.isValidURI((String)str) ? new URIImpl(str) : new LiteralImpl(str);
        }
        this.setActionParameter(request, val);
    }

    public void setActionParameter(HttpServletRequest request, Value val) throws ServletException {
        this.actionParameter = val;
        this.setMetadataInternal(request, REPO.ACTION_PARAMETER, val);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, Value newVal) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to modify Transitions.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, property, null, new Resource[]{REPO.NG_INTERNAL});
            if (newVal != null) {
                rc.add((Resource)this.uri, property, newVal, new Resource[]{REPO.NG_INTERNAL});
                log.debug((Object)("Setting Transition uri=" + this.uri + ", property=" + property + " to value=" + newVal));
            } else {
                log.debug((Object)("Clearing Transition uri=" + this.uri + ", property=" + property));
            }
            this.dirty = true;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void commit(HttpServletRequest request) throws ServletException {
        try {
            if (this.dirty) {
                WithRepositoryConnection.get((ServletRequest)request).commit();
            }
            this.dirty = false;
        }
        catch (OpenRDFException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String toString() {
        return "<#Transition: uri=" + this.uri.toString() + ", label=" + this.label + ">";
    }

    public boolean equals(Object other) {
        return other instanceof WorkflowTransition && this.uri.equals(((WorkflowTransition)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doExportTransitions(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            RDFWriter out = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            out.startRDF();
            for (WorkflowTransition t : WorkflowTransition.findAll((HttpServletRequest)request)) {
                URI tu = t.getURI();
                String tus = tu.stringValue();
                String tl = t.getLabel();
                if (excludes.contains(tl) || excludes.contains(tus)) {
                    log.debug((Object)("SKIP TRANSITION because of exclude: " + t));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(tl) || includes.contains(tus)) {
                    RepositoryResult rr = null;
                    try {
                        rr = rc.getStatements((Resource)tu, null, null, false, new Resource[]{REPO.NG_INTERNAL});
                        while (rr.hasNext()) {
                            out.handleStatement((Statement)rr.next());
                        }
                    }
                    finally {
                        rr.close();
                    }
                    for (Statement s : Access.exportGrants((URI)tu, (Iterable)Access.getGrants((HttpServletRequest)request, (URI)tu))) {
                        out.handleStatement(s);
                    }
                    continue;
                }
                log.debug((Object)("SKIP TRANSITION because of include: " + t));
            }
            out.endRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static void doImportTransitions(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, ImportExport.DuplicateArg duplicate, boolean transform, boolean ignoreACL) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            String qs = "SELECT DISTINCT * WHERE " + transitionQueryPrefix + "}" + "ORDER BY ?order ?label";
            log.debug((Object)("SPARQL query on imported statements: \n  " + qs));
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(false);
            transitionHandler hdl = new transitionHandler();
            q.evaluate((TupleQueryResultHandler)hdl);
            HashSet<URI> existingURI = new HashSet<URI>();
            HashMap<String, URI> existingLabel = new HashMap<String, URI>();
            for (WorkflowTransition e : WorkflowTransition.findAll((HttpServletRequest)request)) {
                URI u = e.getURI();
                existingURI.add(u);
                existingLabel.put(e.getLabel(), u);
            }
            for (WorkflowTransition t : transitionHandler.access$000((transitionHandler)hdl)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("import Transition: Got raw result: " + t));
                }
                URI tu = t.getURI();
                String us = tu.stringValue();
                String ls = t.getLabel();
                if (excludes.contains(us) || excludes.contains(ls)) {
                    log.debug((Object)("SKIP IMPORT TRANSITION because of exclude: uri=" + us + ", label=" + ls));
                    continue;
                }
                if (!(includes.isEmpty() || includes.contains(us) || includes.contains(ls))) {
                    log.debug((Object)("SKIP IMPORT TRANSITION because of include: uri=" + us + ", label=" + ls));
                    continue;
                }
                URI du = null;
                if (existingURI.contains(tu)) {
                    du = tu;
                } else if (existingLabel.containsKey(ls)) {
                    du = (URI)existingLabel.get(ls);
                }
                if (du != null) {
                    log.debug((Object)("Found a duplicate Transition uri=" + du.stringValue()));
                    if (duplicate == ImportExport.DuplicateArg.ignore) {
                        log.debug((Object)("SKIPPING duplicate Transition, input uri=" + us));
                        continue;
                    }
                    if (duplicate == ImportExport.DuplicateArg.abort) {
                        throw new HandlerBadRequest("Import contains a duplicate Transition for existing Transition uri=" + du.stringValue());
                    }
                    if (duplicate == ImportExport.DuplicateArg.replace) {
                        WorkflowTransition orig = WorkflowTransition.find((HttpServletRequest)request, (URI)du);
                        orig.delete(request);
                    }
                }
                URI nu = t.write(request, transform);
                if (ignoreACL) continue;
                for (Statement s : Access.importGrants((HttpServletRequest)request, (RepositoryConnection)content, (URI)tu, (URI)nu)) {
                    log.debug((Object)("Adding access grant stm: " + s));
                    rc.add(s, new Resource[]{REPO.NG_INTERNAL});
                }
            }
        }
        catch (HandlerBadRequest e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ URI access$302(WorkflowTransition x0, URI x1) {
        x0.workspace = x1;
        return x0.workspace;
    }

    static /* synthetic */ String access$402(WorkflowTransition x0, String x1) {
        x0.workspaceLabel = x1;
        return x0.workspaceLabel;
    }

    static /* synthetic */ String access$502(WorkflowTransition x0, String x1) {
        x0.initialLabel = x1;
        return x0.initialLabel;
    }

    static /* synthetic */ String access$602(WorkflowTransition x0, String x1) {
        x0.finalLabel = x1;
        return x0.finalLabel;
    }

    static /* synthetic */ Literal access$702(WorkflowTransition x0, Literal x1) {
        x0.order = x1;
        return x0.order;
    }

    static /* synthetic */ WorkflowAction access$802(WorkflowTransition x0, WorkflowAction x1) {
        x0.action = x1;
        return x0.action;
    }

    static /* synthetic */ Value access$902(WorkflowTransition x0, Value x1) {
        x0.actionParameter = x1;
        return x0.actionParameter;
    }
}

