<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%@ page import="java.io.File" %>
<%@ page import="java.util.Calendar" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="org.eaglei.repository.DataRepository" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>eagle-i Repository Admin - <%= StringEscapeUtils.escapeHtml(DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(title not set)")) %></title>
  </head>
  <body bgcolor=lightyellow>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h3>Status and Configuration</h3>
    <ul>
      <li>Repository webapp
          <a href="/repository/version">version</a>: <tt><b><%= StringEscapeUtils.escapeHtml(DataRepository.getInstance().getProjectVersion()) %></b></tt>,
          built <tt><b><%= StringEscapeUtils.escapeHtml(DataRepository.getInstance().getTimestamp()) %></b></tt>,
          SCM revision <tt><b><%= StringEscapeUtils.escapeHtml(DataRepository.getInstance().getRevision()) %></b></tt>
            (on <%= DataRepository.getInstance().getBranch() == null ? "trunk)" :
            "branch <tt><b>"+StringEscapeUtils.escapeHtml(DataRepository.getInstance().getBranch())+"</b></tt>)" %>
      </li>
      <li>OpenRDF Sesame Version: <tt><b><%= DataRepository.getInstance().getSesameVersion() %></b></tt>
      </li>
      <li>Java info:  <a href="<%= Utils.escapeHTMLAttribute(System.getProperty("java.vendor.url")) %>">
                  <%= StringEscapeUtils.escapeHtml(System.getProperty("java.vendor")) %></a>
                version <tt><b><%= StringEscapeUtils.escapeHtml(System.getProperty("java.version")) %></b></tt>
          </li>
      <li>JVM info:  <%= StringEscapeUtils.escapeHtml(System.getProperty("java.vm.vendor")) %>
                version <tt><b><%= StringEscapeUtils.escapeHtml(System.getProperty("java.vm.version")) %></b></tt>,
                named <tt><b><%= StringEscapeUtils.escapeHtml(System.getProperty("java.vm.name")) %></b></tt>,
                installed in <tt><b><%= StringEscapeUtils.escapeHtml(System.getProperty("java.home")) %></b></tt>
          </li>
      <li>JVM Memory: <tt><b><%= String.format("%,d", Runtime.getRuntime().totalMemory()) %></b></tt>  bytes allocated,
                      <tt><b><%= String.format("%,d", Runtime.getRuntime().freeMemory()) %></b></tt>  bytes free,
                      <tt><b><%= String.format("%,d", Runtime.getRuntime().maxMemory()) %></b></tt>  bytes maximum available.
                          <a href="memory-report.jsp"><i>More Details...</i></a>
          <br></li>
      <li>Default RDF Namespace: <tt><b><%= StringEscapeUtils.escapeHtml(DataRepository.getInstance().getDefaultNamespace()) %></b></tt></li>
<%
    File homeDir = DataRepository.getInstance().getHomeDirectory();
    String logDir = DataRepository.getInstance().getConfigurationProperty("eaglei.repository.log.dir");
    if (logDir == null)
        logDir = new File(homeDir, "logs").toString() + " (default value)";
%>
      <li>Home Directory: <tt><b><%= StringEscapeUtils.escapeHtml(homeDir.toString()) %></b></tt></li>
      <li>Log Directory: <tt><b><%= StringEscapeUtils.escapeHtml(logDir) %></b></tt></li>
<%
    String xslt = DataRepository.getInstance().getConfigurationProperty("eaglei.repository.instance.xslt");
    if (xslt != null) {
%>
        <li>Dissemination XSLT stylesheet: <tt><b><%= StringEscapeUtils.escapeHtml(xslt) %></b></tt></li>
<%
    }
    long up = (System.currentTimeMillis() - DataRepository.STARTUP.getTime()) / 1000;
    long sec = up >= 60 ? up % 60 : up;
    up /= 60;
    long min = up >= 60 ? up % 60 : up;
    up /= 60;
    long hours = up >= 24 ? up % 24 : up;
    long days = up / 24;
    StringBuilder ut = new StringBuilder();;
    if (days > 0)
        ut.append(String.format("%d day%s%s", days, days>1 ? "s":"", days>7?"":", "));
    if (days <= 7)
        ut.append(String.format("%01d:%02d:%02d hrs", hours, min, sec));
    String uptime = ut.toString();
    // time format 2010-12-14 17:41:31
    String started = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz").format(DataRepository.STARTUP);
%>
        <li>Uptime: <tt><b><%= uptime %></b></tt>, started <tt><b><%= StringEscapeUtils.escapeHtml(started) %></b></tt></li>
    </ul>

        <h3>User Tasks (logged in: <tt><b><%= StringEscapeUtils.escapeHtml(request.getRemoteUser()) %></b></tt>)</h3>
        <ul>
          <li>
            <A HREF="/repository/logout">Logout</A>
<i>(You must also clear browser credentials, see <a href="#f1">[1]</a> below.)</I>
          </li>
          <li>
            <A HREF="/repository/query/">SPARQL Query Workbench</A>
          </li>
          <li>
            <A HREF="/repository/admin/editUserPortlet.jsp?standalone">Manage your login account</A>
          </li>
          <li>
            List <a href="/repository/harvest?detail=identifier">Published Resources</a>
          </li>
        </ul>

<%
    if (Authentication.isSuperuser(request)) {
%>
        <h3>Administrator Tasks</h3>
        <ul>
          <li>
            <A HREF="/repository/admin/users.jsp">Manage User Accounts</A> (Authentication Credentials)
          </li>
          <li>
            <A HREF="/repository/admin/roles.jsp">Manage Access Roles</A>
          </li>
          <li>
            <A HREF="/repository/admin/transitions.jsp">Manage Workflow Transitions</A>
          </li>
          <li>
            <a href="/repository/admin/namedGraphs.jsp">Manage Named Graphs</a>
          </li>
          <li>
            <a href="/repository/model">Show Data Model Ontology versions</a>
          </li>
        </ul>
<%
    }
%>

<h3>Help Topics</h3>
<ol>
  <li>
<p><a name="f1"><b>Clearing Browser Authentication:</b></a>
The repository uses
<a href="http://www.ietf.org/rfc/rfc2617.txt">
HTTP Basic Authentication</a> to identify users.
Most web browsers cache the last basic auth entry and don't offer an easy
way to clear it.</p>
<p>
For Mozilla Firefox 3, try the
<a href="https://addons.mozilla.org/en-US/firefox/addon/60/">Web Developer add-on</a>
and select <b>Miscellaneous->Clear Private Data->HTTP Authentication</b> from
its menus.</p>
  </li>
</ol>


  </body>
</html>

 
