<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -
   - Transitions Admin paeg - present a list with columns:
   -   1. Label (which is also a link to edit the transition)
   -   2.  description
   -   3.  workspace
   -   4.  initial state
   -   5.  final state
   -   6.  delete button
   -
   -  Args:
   -   action=delete -- delete a transition, uri must be specified
   -    (default action is just to list trans; create is done by the edit page)
   -   uri - URI of trans to act on
   -   mine - if arg present, show only my accessible transitions
   -     NOTE: This is a kludge for the convenience of testing only!
  --%>
<%@ page import="java.sql.Connection" %>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.HashMap" %>
<%@ page import="java.util.Set" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.sql.Connection" %>
<%@ page import="java.sql.SQLException" %>

<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.model.impl.URIImpl" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>

<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.workflow.WorkflowTransition" %>
<%@ page import="org.eaglei.repository.workflow.WorkflowState" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.BadRequestException" %>
<%@ page import="org.eaglei.repository.status.NotFoundException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>

  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository Admin - Manage Workflow Transitions</title>
  </head>
<%
    Logger log = LogManager.getLogger("org.eaglei.repository.admin.transitions.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");
        // MUST call this before getting any parameters
        request.setCharacterEncoding("UTF-8");
        String action = request.getParameter("action");
        String uri = request.getParameter("uri");
        boolean mine = request.getParameter("mine") != null;

        if (action != null) {
            if (uri == null || uri.length() == 0)
                throw new BadRequestException("You must specify a uri for this action.");

            // delete a transition
            if (action.equals("delete")) {
                WorkflowTransition t = WorkflowTransition.find(request, new URIImpl(uri));
                if (t == null)
                    throw new NotFoundException("No such transition, uri="+uri);
                t.delete(request);
                t.commit(request);
                messageSuccess = true;
                message = "Deleted transition \""+t.getLabel()+"\"";
            } else {
                throw new BadRequestException("Unrecognized value of 'action' arg: \""+action+"\"");
            }
        }
%>
  <body bgcolor=lightyellow>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Manage Workflow Transitions</h2>

<%
        if (message != null) {
%>
    <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
    </h3>
<%
        }
%>
     <h3>&#x26ab; <a href="/repository/admin/editTransition.jsp?create">
         Create a New Workflow Transition</a>
     </h3>
    <h3>&#x26ab; Manage Existing Workflow Transitions</h3>
    <!-- columns: label, comment, delete? -->
    <div style="margin: 0px 0px 0px 30px;">
    <table border="1">
    <tr>
      <th>Transition</th>
      <th>Description</th>
      <th>Workspace</th>
      <th>Initial State</th>
      <th>Final State</th>
      <th colspan="2">Actions</th>
    </tr>
<%
    for (WorkflowTransition t : WorkflowTransition.findAccessibleByAttributes(request, null, null, null, mine ? Authentication.getPrincipalURI(request) : null)) {
        String turi = t.getURI().stringValue();
        String euri = Utils.urlEncode(turi);
        String rc = t.getComment();
        String wl = t.getWorkspaceLabel();
        String il = t.getInitialLabel();
        String fl = t.getFinalLabel();
        String tl = t.getLabel();
        // be sure there are no single or double-quotes to screw up javascript
        String deleteLabel = Utils.escapeHTMLAttribute(tl.replace("\"", "`").replace("'","`"));
 %>
        <tr>
          <td>
            <a href="/repository/admin/editTransition.jsp?uri=<%= Utils.escapeHTMLAttribute(euri) %>">
                  <tt><%= StringEscapeUtils.escapeHtml(tl) %></tt>
            </a>
          </td>

          <td>
            <%=  rc == null ? "&nbsp;" : StringEscapeUtils.escapeHtml(rc) %>
          </td>

          <td>
            <%=  wl == null ? "<i>all</i>" : StringEscapeUtils.escapeHtml(wl) %>
          </td>

          <td>
            <%=  il == null ? "<i>ERROR - missing initial state</i>" : StringEscapeUtils.escapeHtml(il) %>
          </td>

          <td>
            <%=  fl == null ? "<i>ERROR - missing final state</i>" : StringEscapeUtils.escapeHtml(fl) %>
          </td>

          <td>
              <form style="margin: 0pt;" action="/repository/admin/editGrants.jsp">
                <input type="hidden" name="type" value="Workflow Transition" />
                <input type="hidden" name="label" value="<%= Utils.escapeHTMLAttribute(tl) %>"/>
                <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(turi) %>"/>
                <input type="hidden" name="lock_access" value="<%= Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) %>"/>
                <button type="submit">Edit ACL</button></form>
          </td>

          <td>
            <a onclick="javascript:return confirm('Are you SURE you want to delete Transition &quot;<%= deleteLabel %>&quot; ?  It CANNOT be un-done.')"
               href="/repository/admin/transitions.jsp?action=delete&amp;uri=<%= StringEscapeUtils.escapeHtml(euri) %>">
              &#x2620 <i>Delete</i>
            </a>
          </td>
        </tr>
<%
    }
 %>
    </table>
    <i>Click on Transition's label to edit its properties.</i>
    </div>

    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
