package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.model.URI;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.model.User;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.status.ErrorSendingException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.Configuration;
import org.apache.commons.lang.StringEscapeUtils;

public final class editGrants_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/repository/admin/../head.jsp");
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n  <head>\n    ");
      out.write("\n\n\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n<style type=\"text/css\">\n BODY { background-color: ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.admin.backgroundColor", "lightyellow")) );
      out.write("; }\n .ei_required { color: red; }\n</style>\n");
      out.write("\n    <title>Eagle-I Data Repository Admin - Edit Access Control List</title>\n  </head>\n");

    try {
        request.setCharacterEncoding("UTF-8");
        // feedback message about status of any chosen operation
        String message = request.getParameter("message");
        boolean messageSuccess = true;
        URI lock_access = Utils.parseURI(request.getParameter("lock_access"), "lock_access", false);
        String type = request.getParameter("type");
        if (type == null)
            type = "Unknown-type";
        String backLink = request.getParameter("backLink");
        if (backLink == null)
            backLink = request.getHeader("Referer");  // "[sic]"
        String backLabel = request.getParameter("backLabel");
        String label = request.getParameter("label");
        if (label == null)
            label = "";
        URI uri = Utils.parseURI(request.getParameter("uri"), "uri", true);

      out.write("\n  <body>\n    ");
      out.write('\n');
      out.write("\n\n\n<hr/>\n  <table border=\"0\" width=\"100%\" >\n    <tr>\n      <td width=\"30%\">\n        <a href=\"/repository/admin/\">\n          <img border=\"0\" alt=\"Institutional Logo\" align=\"right\" src=\"");
      out.print( Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" />\n        </a>\n      </td>\n      <td width=\"70%\"><div align=\"center\">\n            <font size=\"+1\" color=\"black\">\n              ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)")) );
      out.write("</p>\n            </font>\n        </div>\n        <div align=\"center\" style=\"margin-top: 0.5em;\">Data Repository Administration</div>\n      </td>\n    </tr>\n  </table>\n<hr/>\n");
      out.write("\n    <h2>Edit Access to a ");
      out.print( StringEscapeUtils.escapeHtml(type) );
      out.write("</h2>\n    <h3>\n     ");
 if (label != null && label.length() > 0)
            out.write("Name: "+StringEscapeUtils.escapeHtml(label)+"<br/>"); 
      out.write("\n     URI: <code>&nbsp;");
      out.print( StringEscapeUtils.escapeHtml(uri.stringValue()) );
      out.write("</code>\n    </h3>\n");

    if (message != null) {

      out.write("\n      <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n     </h3>\n");

    }

      out.write("\n\n   <h2>Current Access Grants:</h2>\n    <table border=\"1\">\n      <tr><th>Agent</th><th>Access Type</th><th>Delete</th></tr>\n");

    for (AccessGrant g : AccessGrant.getGrants(request, uri)) {

      out.write("\n      <tr>\n        <td>\n        ");
      out.print( StringEscapeUtils.escapeHtml(g.getAgentLabel()) );
      out.write("\n        [");
      out.print( StringEscapeUtils.escapeHtml(g.getAgentTypeLabel()) );
      out.write("]\n        </td>\n        <td>");
      out.print( StringEscapeUtils.escapeHtml(g.getAccessLabel()) );
      out.write("</td>\n        <td>\n         <form accept-charset=\"UTF-8\" method=\"post\" action=\"/repository/admin/updateGrants\" style=\"margin: 0pt;\">\n");
      if (backLink != null) { 
      out.write("\n         <input type=\"hidden\" name=\"backLink\" value=\"");
      out.print( Utils.escapeHTMLAttribute( backLink) );
      out.write("\"/>\n");
      } 
      out.write('\n');
  if (backLabel != null) { 
      out.write("\n         <input type=\"hidden\" name=\"backLabel\" value=\"");
      out.print( Utils.escapeHTMLAttribute( backLabel) );
      out.write("\"/>\n");
      } 
      out.write("\n         <input type=\"hidden\" name=\"type\" value=\"");
      out.print( Utils.escapeHTMLAttribute(type) );
      out.write("\"/>\n         <input type=\"hidden\" name=\"label\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n         <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute( uri.toString()) );
      out.write("\"/>\n         <input type=\"hidden\" name=\"action\" value=\"remove\"/>\n         <input type=\"hidden\" name=\"agent\" value=\"");
      out.print( Utils.escapeHTMLAttribute(g.getAgentURI().stringValue()) );
      out.write("\"/>\n         <input type=\"hidden\" name=\"access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(g.getAccessURI().stringValue()) );
      out.write("\"/>\n");
  if (lock_access != null) { 
      out.write("\n         <input type=\"hidden\" name=\"lock_access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(lock_access.stringValue()) );
      out.write("\"/>\n");
      } 
      out.write("\n          <button type=\"submit\">Delete!</button>\n         </form>\n        </td>\n      </tr>\n");

    }

      out.write("\n    </table>\n\n  <h2>Add New Access Grant:</h2>\n\n   <form accept-charset=\"UTF-8\" method=\"post\" action=\"/repository/admin/updateGrants\">\n");
  if (backLink != null) { 
      out.write("\n    <input type=\"hidden\" name=\"backLink\" value=\"");
      out.print( Utils.escapeHTMLAttribute( backLink) );
      out.write("\"/>\n");
  } 
      out.write('\n');
  if (backLabel != null) { 
      out.write("\n    <input type=\"hidden\" name=\"backLabel\" value=\"");
      out.print( Utils.escapeHTMLAttribute( backLabel) );
      out.write("\"/>\n");
  } 
      out.write("\n    <input type=\"hidden\" name=\"type\" value=\"");
      out.print( Utils.escapeHTMLAttribute( type) );
      out.write("\"/>\n    <input type=\"hidden\" name=\"label\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n    <input type=\"hidden\" name=\"action\" value=\"add\"/>\n    <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute( uri.toString()) );
      out.write("\"/>\n");
  if (lock_access != null) { 
      out.write("\n          <input type=\"hidden\" name=\"lock_access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(lock_access.stringValue()) );
      out.write("\"/>\n");
      } 
      out.write("\n   <div style=\"width: 50%;\">\n    <fieldset style=\"width: 80%; align: center;\">\n     <legend><b>Choose Agent to have Access</b></legend>\n       <font size=\"-1\"><i>Select EITHER a user OR role:</i></font><br/>\n       <b>User:</b>\n       <select name=\"agent\">\n         <option value=\"\">--none--</option>\n");

    for (User u : User.findAll(request)) {
        if (u.getURI() != null) {

      out.write("\n            <option value=\"");
      out.print( Utils.escapeHTMLAttribute( u.getURI().stringValue()) );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(u.getLabel()) );
      out.write("</option>\n");

        }
    }

      out.write("\n       </select>\n       <br>&nbsp;&nbsp;&nbsp;<b>-- or --</b>\n       <br>\n       <b>Role:</b>\n       <select name=\"agent\">\n         <option value=\"\">--none--</option>\n");

    for (Role r : Role.findAllGrantable(request)) {

      out.write("\n            <option value=\"");
      out.print( Utils.escapeHTMLAttribute( r.getURI().stringValue()) );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(r.getLabel()) );
      out.write("</option>\n");

    }

      out.write("\n          </select>\n    </fieldset>\n    <p>\n\n   <b>Access Type:</b>\n         <select name=\"access\">\n           <option value=\"\" ");
      out.print( lock_access == null ? "" : "disabled" );
      out.write(">--none--</option>\n");

    for (Access a : Access.values()) {
        URI aURI = a.getURI();

      out.write("\n           <option value=\"");
      out.print( Utils.escapeHTMLAttribute( aURI.stringValue()) );
      out.write("\"\n             ");
      out.print( lock_access == null ? "" : (aURI.equals(lock_access) ? "selected" : "disabled") );
      out.write(">\n             ");
      out.print( StringEscapeUtils.escapeHtml(a.toString()) );
      out.write("\n           </option>\n");

    }

      out.write("\n         </select>\n    <p>\n    <div width=\"50%\" align=\"center\">\n      <button type=\"reset\">Reset Form</button>\n      &nbsp;&nbsp;&nbsp;&nbsp;\n      <button name=\"submit\" value=\"submit\" type=\"submit\">Add!</button>\n    </div>\n   </div>\n\n   </form>\n");

    if (backLink != null) {
        if (backLabel == null)
            backLabel = "Back to previous page";

      out.write("\n    <br/>\n    <br/>\n    <a href=\"");
      out.print( Utils.escapeHTMLAttribute( backLink) );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(backLabel) );
      out.write("</a>\n");
      } 
      out.write("\n    <br/>\n    <br/>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n  </body>\n");

    // see "try" at start of body tag.
    // This is the idiom that much of the repo code uses to pass
    // HTTP status results back as a RuntimeException subclass..
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
