package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.model.URI;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.util.Utils;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.Configuration;
import org.apache.commons.lang.StringEscapeUtils;

public final class editGraph_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    // output a provenance "entry" for created or modified, they are similar.
    private void provEntry(HttpServletRequest request, JspWriter out, Provenance p, String label, String when, String who)
        throws IOException
    {
        if (when == null)
            return;
        String whoLabel = null;
        if (who != null)
            whoLabel = p.getField(request, Utils.parseURI(who, "who", true));
        out.append("<li><b>").append(label).append(":</b> <tt>").
            append(when).append("</tt>");
        if (who != null) {
            out.append(", by ");
            if (whoLabel == null)
                out.append(who);
            else
                out.append("<a href=\"").append(who).append("\">").
                    append(whoLabel).append("</a>");
        }
        out.append("</li>");
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/repository/admin/../head.jsp");
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n  <head>\n    ");
      out.write("\n\n\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n<style type=\"text/css\">\n BODY { background-color: ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.admin.backgroundColor", "lightyellow")) );
      out.write("; }\n .ei_required { color: red; }\n</style>\n");
      out.write("\n    <title>Eagle-I Data Repository Admin - Edit Named Graph Metadata</title>\n  </head>\n");
      out.write('\n');

    try {
        // sanity-check args
        request.setCharacterEncoding("UTF-8");
        URI uri = Utils.parseURI(request.getParameter("uri"), "uri", true);

        // feedback message about status of any chosen operation
        String message = request.getParameter("message");
        boolean messageSuccess = true;

        NamedGraph ng = NamedGraph.find(request, uri);
        if (ng == null)
            throw new BadRequestException("This URI is not a named graph or managed context: "+uri.stringValue());
        String label = ng.getLabel();
        if (label == null)
            label = "";

      out.write("\n  <body>\n    ");
      out.write('\n');
      out.write("\n\n\n<hr/>\n  <table border=\"0\" width=\"100%\" >\n    <tr>\n      <td width=\"30%\">\n        <a href=\"/repository/admin/\">\n          <img border=\"0\" alt=\"Institutional Logo\" align=\"right\" src=\"");
      out.print( Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" />\n        </a>\n      </td>\n      <td width=\"70%\"><div align=\"center\">\n            <font size=\"+1\" color=\"black\">\n              ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)")) );
      out.write("</p>\n            </font>\n        </div>\n        <div align=\"center\" style=\"margin-top: 0.5em;\">Data Repository Administration</div>\n      </td>\n    </tr>\n  </table>\n<hr/>\n");
      out.write("\n    <h2 align=\"center\">Edit Named Graph Metadata</h2>\n    <h3 align=\"center\"><tt>");
      out.print( StringEscapeUtils.escapeHtml( uri.stringValue()) );
      out.write("</tt></h3>\n");

    if (message != null) {

      out.write("\n      <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n     </h3>\n");

    }

      out.write('\n');
      out.write('\n');

    Provenance p = new Provenance(uri);
    String created = p.getField(request, DCTERMS.CREATED);
    String creator = p.getField(request, DCTERMS.CREATOR);
    String modified = p.getField(request, DCTERMS.MODIFIED);
    String contributor = p.getField(request, DCTERMS.CONTRIBUTOR);
    String sourceIdentifier = p.getField(request, DCTERMS.SOURCE_IDENTIFIER);
    String sourceModified = p.getField(request, DCTERMS.SOURCE_MODIFIED);
    if (created != null || modified != null || sourceIdentifier != null) {

      out.write("\n    <h3>Provenance Metadata:</h3>\n    <ul>\n");

        provEntry(request, out, p, "Created", created, creator);
        provEntry(request, out, p, "Last modified", modified, contributor);

      out.write('\n');
      out.write('\n');

        if (sourceIdentifier != null) {

      out.write("\n        <li><b>From:</b> <tt>");
      out.print( StringEscapeUtils.escapeHtml( sourceIdentifier) );
      out.write("</tt>\n");

            if (sourceModified != null) {

      out.write(", last modified <tt>");
      out.print( StringEscapeUtils.escapeHtml( sourceModified) );
      out.write("</tt>\n");

            }

      out.write("\n        </li>\n");

        }

      out.write("\n    </ul>\n");

    }

      out.write("\n\n    <form method=\"POST\" action=\"/repository/admin/updateNamedGraph\">\n      <fieldset style=\"width: 80%; align: center;\">\n       <legend><b>Modify Named Graph Properties</b></legend>\n       <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(uri.stringValue()) );
      out.write("\"/>\n       <p><b>Label:</b> <input type=\"text\" name=\"label\" size=\"50\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n       </p>\n       <p><b>Named Graph Type:</b> <select name=\"type\">\n");

    if (ng.getType() == null) {

      out.write("\n          <option selected=\"t\" value=\"\"> --none-- </option>\n");

    }
    for (NamedGraphType t : NamedGraphType.findAll(request)) {

      out.write("\n          <option ");
      out.print( t == ng.getType() ? "selected=\"t\"" : "" );
      out.write("\n            value=\"");
      out.print( Utils.escapeHTMLAttribute(t.getURI().stringValue()) );
      out.write("\">\n            ");
      out.print( StringEscapeUtils.escapeHtml(t.getLabel()) );
      out.write("\n          </option>\n");

    }

      out.write("\n        </select>\n        </p>\n        <div width=\"50%\" align=\"left\">\n          <div width=\"50%\" align=\"center\">\n            <button type=\"reset\">Reset Form</button>\n            &nbsp;&nbsp;&nbsp;&nbsp;\n            <button name=\"submit\" value=\"submit\" type=\"submit\">Submit</button>\n          </div>\n        </div>\n      </fieldset>\n    </form>\n\n    <form  action=\"/repository/admin/editGrants.jsp\">\n      <fieldset style=\"width: 80%; align: center;\">\n       <legend><b>Change Named Graph Access</b></legend>\n      <input type=\"hidden\" name=\"type\" value=\"Named Graph\" />\n      <input type=\"hidden\" name=\"label\" value=\"");
      out.print( Utils.escapeHTMLAttribute(label) );
      out.write("\"/>\n      <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(ng.getURI().stringValue()) );
      out.write("\"/>\n      <button type=\"submit\">Edit ACL</button><i> (Leaves this page)</i>\n     </fieldset>\n    </form>\n    <p></p>\n    <p>\n    <a href=\"/repository/admin/namedGraphs.jsp\">Return to Named Graphs</a>\n    </p>\n    <p>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n    </p>\n  </body>\n");

    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
