package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.model.workflow.ErrorAction;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.status.ForbiddenException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.Configuration;
import org.apache.commons.lang.StringEscapeUtils;

public final class transitions_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/repository/admin/../head.jsp");
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n  <head>\n    ");
      out.write("\n\n\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n<style type=\"text/css\">\n BODY { background-color: ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.admin.backgroundColor", "lightyellow")) );
      out.write("; }\n .ei_required { color: red; }\n</style>\n");
      out.write("\n    <title>Eagle-I Data Repository Admin - Manage Workflow Transitions</title>\n  </head>\n");

    // MUST call this before getting any parameters
    request.setCharacterEncoding("UTF-8");
    // feedback message about status of any chosen operation
    String message = request.getParameter("message");
    boolean messageSuccess = true;

    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        boolean mine = request.getParameter("mine") != null;

      out.write("\n  <body>\n    ");
      out.write('\n');
      out.write("\n\n\n<hr/>\n  <table border=\"0\" width=\"100%\" >\n    <tr>\n      <td width=\"30%\">\n        <a href=\"/repository/admin/\">\n          <img border=\"0\" alt=\"Institutional Logo\" align=\"right\" src=\"");
      out.print( Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" />\n        </a>\n      </td>\n      <td width=\"70%\"><div align=\"center\">\n            <font size=\"+1\" color=\"black\">\n              ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)")) );
      out.write("</p>\n            </font>\n        </div>\n        <div align=\"center\" style=\"margin-top: 0.5em;\">Data Repository Administration</div>\n      </td>\n    </tr>\n  </table>\n<hr/>\n");
      out.write("\n    <h2>Manage Workflow Transitions</h2>\n\n");

        if (message != null) {

      out.write("\n    <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n    </h3>\n");

        }

      out.write("\n     <h3>&#x26ab; <a href=\"/repository/admin/editTransition.jsp?create\">\n         Create a New Workflow Transition</a>\n     </h3>\n    <h3>&#x26ab; Manage Existing Workflow Transitions</h3>\n    <!-- columns: label, comment, delete? -->\n    <div style=\"margin: 0px 0px 0px 30px;\">\n    <table border=\"1\">\n    <tr>\n      <th>Transition</th>\n      <th>Description</th>\n      <th>Workspace</th>\n      <th>Initial State</th>\n      <th>Final State</th>\n      <th colspan=\"2\">Actions</th>\n    </tr>\n");

    for (WorkflowTransition t : WorkflowTransition.findAccessibleByAttributes(request, null, null, null, mine ? Authentication.getPrincipalURI(request) : null)) {
        String turi = t.getURI().stringValue();
        String euri = Utils.urlEncode(turi);
        String rc = t.getComment();
        String wl = t.getWorkspaceLabel();
        String il = t.getInitialLabel();
        String fl = t.getFinalLabel();
        String tl = t.getLabel();
        // be sure there are no single or double-quotes to screw up javascript
        String deleteLabel = Utils.escapeHTMLAttribute(tl.replace("\"", "`").replace("'","`"));
 
      out.write("\n        <tr>\n          <td>\n            <a href=\"/repository/admin/editTransition.jsp?uri=");
      out.print( Utils.escapeHTMLAttribute(euri) );
      out.write("\">\n                  <tt>");
      out.print( StringEscapeUtils.escapeHtml(tl) );
      out.write("</tt>\n            </a>\n          </td>\n\n          <td>\n            ");
      out.print(  rc == null ? "&nbsp;" : StringEscapeUtils.escapeHtml(rc) );
      out.write('\n');

            if (t.isErrorAction()) {
 
      out.write("\n            <br/>\n            <span style=\"color: red; font-style: italic;\">\n             ");
      out.print( ((ErrorAction)t.getAction()).getMessage() );
      out.write("\n            </span>\n");

            }
 
      out.write("\n          </td>\n\n          <td>\n            ");
      out.print(  wl == null ? "<i>all</i>" : StringEscapeUtils.escapeHtml(wl) );
      out.write("\n          </td>\n\n          <td>\n            ");
      out.print(  il == null ? "<i>ERROR - missing initial state</i>" : StringEscapeUtils.escapeHtml(il) );
      out.write("\n          </td>\n\n          <td>\n            ");
      out.print(  fl == null ? "<i>ERROR - missing final state</i>" : StringEscapeUtils.escapeHtml(fl) );
      out.write("\n          </td>\n\n          <td>\n              <form style=\"margin: 0pt;\" action=\"/repository/admin/editGrants.jsp\">\n                <input type=\"hidden\" name=\"type\" value=\"Workflow Transition\" />\n                <input type=\"hidden\" name=\"label\" value=\"");
      out.print( Utils.escapeHTMLAttribute(tl) );
      out.write("\"/>\n                <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(turi) );
      out.write("\"/>\n                <input type=\"hidden\" name=\"lock_access\" value=\"");
      out.print( Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) );
      out.write("\"/>\n                <button type=\"submit\">Edit ACL</button></form>\n          </td>\n\n          <td>\n    <form action=\"/repository/admin/updateTransition\" method=\"POST\"\n          onclick=\"javascript:return confirm('Are you SURE you want to delete Transition &quot;");
      out.print( deleteLabel );
      out.write("&quot; ?  It CANNOT be un-done.')\">\n      <input type=\"hidden\" name=\"uri\" value=\"");
      out.print( Utils.escapeHTMLAttribute(turi) );
      out.write("\"/>\n      <input type=\"hidden\" name=\"action\" value=\"delete\"/>\n      <button name=\"submit\" value=\"submit\" type=\"submit\">&#x2620 <i>Delete</i></button>\n    </form>\n          </td>\n        </tr>\n");

    }
 
      out.write("\n    </table>\n    <i>Click on Transition's label to edit its properties.</i>\n    </div>\n\n    <br/>\n    <br/>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n  </body>\n");

    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
