package org.eaglei.repository;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marker annotation to declare a Class that caches some RDF content
 * in static or singleton memory.  When the entire RDF database is replaced,
 * these classes must drop all references to old content since it may have
 * been changed.
 *
 * A class with this annotation is assumed to implement the static method:
 *  public static void decache()
 * Since an interface cannot include static methods, and a decache method by
 * its nature must be static, we use this annotation instead.
 *
 * @author Larry Stone
 * Started December, 2010
 * @version $Id: $
 */
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value=ElementType.TYPE)
public @interface HasContentCache
{
}
