package org.eaglei.repository.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.repository.RepositoryException;
import org.openrdf.model.URI;

import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.workflow.Workflow;
import org.eaglei.repository.status.ForbiddenException;

/**
 *
 * Args:
 *  uri - URI of the resource instance to claim
 *  user - URI of the user
 *
 * @author Larry Stone
 * @version $Id: $
 * Started October 21, 2010
 */
public class WorkflowClaim extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(WorkflowClaim.class);

    /** {@inheritDoc} */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        URI uri = getParameterAsURI(request, "uri", true);
        URI userURI = getParameterAsURI(request, "user", false);

        // defaulting and sanity-checking
        URI myself = Authentication.getPrincipalURI(request);
        if (userURI == null)
            userURI = myself;
        else if (!(myself.equals(userURI) || Authentication.isSuperuser(request)))
            throw new ForbiddenException("Claiming on behalf of another user requires administrator access.");

        // XXX sanity: test taht userURI is actually a User? maybe later.

        // this will fail if resource isn't visible to current user
        Workflow wf = Workflow.find(request, uri);
        if (log.isDebugEnabled())
            log.debug("CLAIM PARAMETERS:\nresource="+uri+"\nowner="+userURI+"\nstate="+wf.getState()+"\nhome graph="+wf.getHomeGraph());

        // this tests for no existing claim, and access to a transition
        wf.assertClaim(request, userURI);

        try {
            WithRepositoryConnection.get(request).commit();
        } catch (RepositoryException e) {
            throw new ServletException(e);
        }
    }
}
