package org.eaglei.repository.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.repository.RepositoryException;
import org.openrdf.model.URI;

import org.eaglei.repository.model.workflow.Workflow;

/**
 * Servlet to invoke ("push") a workflow transition, on a specific instance.
 * Implementation logic is in the Workflow class.
 *
 * Args:
 *  uri - URI of the resource instance to push
 *  transition - URI of workflow transition to take
 *
 * @author Larry Stone
 * @version $Id: $
 * Started October 21, 2010
 */
public class WorkflowPush extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(WorkflowPush.class);

    /** {@inheritDoc} */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        URI uri = getParameterAsURI(request, "uri", true);
        URI transURI = getParameterAsURI(request, "transition", true);

        // this will fail if resource isn't visible to current user
        Workflow wf = Workflow.find(request, uri);
        if (log.isDebugEnabled())
            log.debug("PUSH PARAMETERS:\nresource="+uri+"\ntransition="+transURI);

        // this tests for existing claim, and access to the transition, etc.
        wf.invokeTransition(request, transURI);
        try {
            WithRepositoryConnection.get(request).commit();
        } catch (RepositoryException e) {
            throw new ServletException(e);
        }
    }
}
