package org.eaglei.repository.status;

import org.eaglei.repository.*;
import javax.servlet.http.HttpServletResponse;

/**
 * Signal a fatal runtime error that should result in a
 * 400 (BAD REQUEST) status returned to the HTTP client.
 *
 * @author lcs
 * @version $Id: $
 */
public class BadRequestException extends ErrorSendingException
{
    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return HttpServletResponse.SC_BAD_REQUEST;
    }

    /**
     * <p>Constructor for BadRequestException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public BadRequestException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for BadRequestException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public BadRequestException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for BadRequestException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public BadRequestException(Throwable cause)
    {
        super(cause);
    }
}
