package org.eaglei.repository.vocabulary;

import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.URI;

/**
 * Constants from the FOAF vocabulary
 * URIs of useful classes and properties.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class FOAF
{
    private FOAF()
    {
    }

    /** Repository Ontology Namespace Preifx (and URI of Named Graph) */
    public static final String NAMESPACE = "http://xmlns.com/foaf/0.1/";
    /** Constant <code>NAMESPACE_URI</code> */
    public static final URI NAMESPACE_URI =  new URIImpl(NAMESPACE);

    /** some useful properties */
    public static final URI FIRST_NAME =  makeURI("firstName");
    /** Constant <code>SURNAME</code> */
    public static final URI SURNAME =  makeURI("surname");
    /** Constant <code>NAME</code> */
    public static final URI NAME =  makeURI("name");
    /** Constant <code>MBOX</code> */
    public static final URI MBOX =  makeURI("mbox");
    /** Constant <code>MBOX_SHA1SUM</code> */
    public static final URI MBOX_SHA1SUM =  makeURI("mbox_sha1sum");

    /** some useful Classes */
    public static final URI AGENT =  makeURI("Agent");
    /** Constant <code>PERSON</code> */
    public static final URI PERSON =  makeURI("Person");
    /** Constant <code>ONLINE_ACCOUNT</code> */
    public static final URI ONLINE_ACCOUNT =  makeURI("OnlineAccount");
    /** Constant <code>PROJECT</code> */
    public static final URI PROJECT =  makeURI("Project");
    /** Constant <code>ORGANIZATION</code> */
    public static final URI ORGANIZATION =  makeURI("Organization");

    /** Utility to create a URI in the REPO namespace out of the given suffix. */
    private static URI makeURI(String id)
    {
        return new URIImpl(NAMESPACE+id);
    }
}
