package org.eaglei.repository.auth;

import java.util.Map;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.ServletException;

import org.openrdf.model.URI;

/**
 * Outline of factory for pluggable authentication user database.
 * It is a singleton that manages DB-wide operations
 *
 * @see AuthUserTomcatFactory
 * @author Larry Stone
 * Started March 2011
 */
public interface AuthUserFactory
{
    /**
     * get the URI identifying this AuthUser implementation.
     * @return the identifying URI
     */
    URI getType();

    /**
     * Create a new auth user in the DB with indicated username.
     * @param username the username to look up
     * @return the new AuthUser that was created
     */
    AuthUser create(String username);

    /**
     * Get the auth-db description of the indicated user, if present.
     * @param targetUsername the username to look up
     * @return a new AuthUserTomcat object or null if not found.
     */
    AuthUser find(String username)
        throws ServletException;

    /**
     * Get a Map of each username key to AuthUserTomcat object.
     * @return Map from username to AuthUser object, never null but maybe empty
     */
    Map<String,? extends AuthUser> findAllAsMap()
        throws ServletException;

    /**
     * Commit a group of modified (or created) entries, more
     * efficient for use by import.
     * @param request the servlet request
     * @param authUsers the users to commit
     */
    void commitMultiple(HttpServletRequest request, Collection<? extends AuthUser> authUsers)
        throws ServletException;
}
