package org.eaglei.repository.servlet;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;

import org.eaglei.repository.Lifecycle;

/**
 * Manage application-wide state by responding to Web Application
 * lifecycle events.  Keep one live Sesame repository object in
 * the Servlet Context.  It *must* be closed when container shuts down.
 *
 * Important configuration variables:
 *  - Sesame repository object (not the connection, it makes connections)
 *  - Default namespace
 *  - Title (in configuration)
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class RepositoryContextListener implements ServletContextListener
{
    private static Logger log = LogManager.getLogger(RepositoryContextListener.class);

    /**
     * {@inheritDoc}
     *
     * Web app initialization hook from servlet container.
     */
    @Override
    public void contextInitialized(ServletContextEvent sce)
    {
        try {
            Lifecycle.initialize(sce.getServletContext());
        } catch (Exception e) {
            log.error("Got exception in Webapp context initialization, EXPECT NOTHING WILL WORK:", e);
        }
    }

    /**
     * {@inheritDoc}
     *
     * Web app destruction hook from servlet container.
     */
    @Override
    public void contextDestroyed(ServletContextEvent sce)
    {
        Lifecycle lc = Lifecycle.getInstance();
        if (lc == null)
            log.error("Data Repository was not successfully initialized, cannot destroy!");
        else {
            try {
                lc.destroy(sce.getServletContext());
            } catch (Exception e) {
                log.error("Got exception in Webapp context finalization, but forging ahead:", e);
            }
        }
        // this is necessary to flush any buffered I/O
        LogManager.shutdown();
    }
}
