package org.eaglei.repository.status;

import org.eaglei.repository.*;
import javax.servlet.http.HttpServletResponse;

/**
 * Signal a fatal runtime error that should result in a
 * 403 (Forbidden) status returned to the HTTP client.
 *
 * @author lcs
 * @version $Id: $
 */
public class ConflictException extends ErrorSendingException
{
    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return HttpServletResponse.SC_CONFLICT;
    }

    /**
     * <p>Constructor for ConflictException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public ConflictException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for ConflictException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public ConflictException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for ConflictException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public ConflictException(Throwable cause)
    {
        super(cause);
    }
}
