package org.eaglei.repository.status;

import org.eaglei.repository.status.ErrorSendingException;
import javax.servlet.http.HttpServletResponse;

/**
 * Signal a fatal runtime error that should result in a
 * 404 (Not Found) status returned to the HTTP client.
 *
 * @author lcs
 * @version $Id: $
 */
public class NotFoundException extends ErrorSendingException
{
    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return HttpServletResponse.SC_NOT_FOUND;
    }
    /**
     * <p>Constructor for NotFoundException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public NotFoundException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for NotFoundException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public NotFoundException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for NotFoundException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public NotFoundException(Throwable cause)
    {
        super(cause);
    }
}
