package org.eaglei.repository.util;

import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.RDFHandlerWrapper;

/**
 * RDF handler that appends the results of multiple parses into one
 * "output" handler.. call startRDF() exactly once, and require
 * the application to call reallyEndRDF().
 */
public class AppendingRDFHandler extends RDFHandlerWrapper
{
    private boolean doStart = true;

    public AppendingRDFHandler(RDFHandler deferTo)
    {
        super(deferTo);
    }

    @Override
    public void startRDF()
        throws RDFHandlerException
    {
        if (doStart) {
            doStart = false;
            super.startRDF();
        }
    }

    @Override
    public void endRDF()
        throws RDFHandlerException
    {
    }

    public void reallyEndRDF()
        throws RDFHandlerException
    {
        super.endRDF();
    }
}
