/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.inferencer;

import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.inferencer.TBoxInferencer;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.inferencer.InferencerConnectionWrapper;

class MinimalInferencerConnection
extends InferencerConnectionWrapper
implements SailConnectionListener {
    private Logger log = LogManager.getLogger(this.getClass());
    private Set<URI> modifiedTBoxGraphs = null;
    private Set<URI> modifiedABoxSubjects = null;
    private int aboxCount = 0;
    private int tboxCount = 0;
    private boolean doingInferencing = false;
    private boolean reInferAllABox = false;
    private ArrayBlockingQueue<URI[]> inferredTypeBuffer = new ArrayBlockingQueue(100000);
    private static Set<URI> tboxGraphs = null;
    private static URI[] tboxGraphsAsArray = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinimalInferencerConnection(InferencerConnection con) {
        super(con);
        con.addConnectionListener((SailConnectionListener)this);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (tboxGraphs == null) {
                tboxGraphs = TBoxInferencer.getInstance().getTBoxGraphs();
                tboxGraphsAsArray = tboxGraphs.toArray(new URI[tboxGraphs.size()]);
                this.log.info((Object)("Initialized TBox graph array = " + Arrays.deepToString(tboxGraphsAsArray)));
            }
        }
    }

    public void statementAdded(Statement st) {
        if (!this.doingInferencing && !this.markTBox(st)) {
            this.markABox(st);
        }
    }

    public void statementRemoved(Statement st) {
        if (!this.doingInferencing && !this.markTBox(st)) {
            this.markABox(st);
        }
    }

    private boolean markTBox(Statement st) {
        Resource ctx = st.getContext();
        if (ctx != null && ctx instanceof URI && tboxGraphs.contains((URI)ctx)) {
            if (this.modifiedTBoxGraphs == null) {
                this.modifiedTBoxGraphs = new HashSet();
            }
            if (this.modifiedTBoxGraphs.add((URI)ctx) && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Marked dirty TBox graph: " + ctx));
            }
            this.reInferAllABox = true;
            if (this.modifiedABoxSubjects != null) {
                this.modifiedABoxSubjects.clear();
            }
            return true;
        }
        return false;
    }

    private boolean markABox(Statement st) {
        if (!this.reInferAllABox && RDF.TYPE.equals(st.getPredicate())) {
            Resource s = st.getSubject();
            Resource ctx = st.getContext();
            if (s != null && s instanceof URI && ctx != null && !REPO.NG_INFERRED.equals((URI)ctx)) {
                if (this.modifiedABoxSubjects == null) {
                    this.modifiedABoxSubjects = new HashSet();
                }
                if (this.modifiedABoxSubjects.add((URI)s)) {
                    // empty if block
                }
                return true;
            }
        }
        return false;
    }

    public void flushUpdates() throws SailException {
        super.flushUpdates();
        this.doInferencing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInferencing() throws SailException {
        try {
            DatasetImpl ds;
            InferencerConnection rc = this.getWrappedConnection();
            long startMs = System.currentTimeMillis();
            boolean touched = false;
            this.aboxCount = 0;
            this.tboxCount = 0;
            this.doingInferencing = true;
            if (this.modifiedTBoxGraphs != null && !this.modifiedTBoxGraphs.isEmpty()) {
                for (URI g : this.modifiedTBoxGraphs) {
                    try {
                        this.tboxCount += TBoxInferencer.getInstance().doTBoxInference(rc, g);
                    }
                    catch (IOException e) {
                        throw new SailException((Throwable)e);
                    }
                    catch (RDFHandlerException e) {
                        throw new SailException((Throwable)e);
                    }
                    touched = true;
                }
                this.modifiedTBoxGraphs.clear();
            }
            if (this.reInferAllABox) {
                rc.clearInferred(new Resource[]{REPO.NG_INFERRED});
                ds = this.getABoxDataset(rc);
                this.doABoxTypeInference(null, (Dataset)ds, rc);
                this.flushInferredTypes(rc);
                touched = true;
            } else if (this.modifiedABoxSubjects != null && !this.modifiedABoxSubjects.isEmpty()) {
                this.log.debug((Object)("Got ABox changes, count=" + this.modifiedABoxSubjects.size()));
                ds = this.getABoxDataset(rc);
                for (URI sub : this.modifiedABoxSubjects) {
                    rc.removeInferredStatement((Resource)sub, RDF.TYPE, null, new Resource[]{REPO.NG_INFERRED});
                }
                for (URI sub : this.modifiedABoxSubjects) {
                    this.doABoxTypeInference(sub, (Dataset)ds, rc);
                }
                this.flushInferredTypes(rc);
                this.modifiedABoxSubjects.clear();
                touched = true;
            }
            if (this.log.isDebugEnabled()) {
                if (touched) {
                    this.log.debug((Object)("flushUpdates: Inferencing summary: added " + this.aboxCount + " statements to ABox, " + this.tboxCount + " to TBox (ontology)" + ", elapsed time = " + String.valueOf(System.currentTimeMillis() - startMs) + " mSec"));
                } else {
                    this.log.debug((Object)"No inferencing changes upon this flushUpdates()");
                }
            }
        }
        finally {
            this.doingInferencing = false;
            this.clearMarks();
        }
    }

    public void rollback() throws SailException {
        this.log.debug((Object)"called rollback()");
        super.rollback();
        this.clearMarks();
    }

    private void clearMarks() {
        if (this.modifiedTBoxGraphs != null) {
            this.modifiedTBoxGraphs.clear();
        }
        this.reInferAllABox = false;
        if (this.modifiedABoxSubjects != null) {
            this.modifiedABoxSubjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doABoxTypeInference(URI subject, Dataset ds, InferencerConnection rc) throws SailException {
        Var sv = new Var("subject");
        if (subject != null) {
            sv.setValue((Value)subject);
        }
        Distinct q = new Distinct((TupleExpr)new StatementPattern(sv, new Var("p", (Value)RDF.TYPE), new Var("object")));
        try {
            CloseableIteration bi = rc.evaluate((TupleExpr)q, ds, (BindingSet)new EmptyBindingSet(), false);
            try {
                while (bi.hasNext()) {
                    BindingSet bs = (BindingSet)bi.next();
                    Value s = bs.getValue("subject");
                    Value t = bs.getValue("object");
                    if (s == null || !(s instanceof URI) || t == null) continue;
                    this.addInferredTypes(rc, (URI)s, (URI)t);
                }
            }
            finally {
                bi.close();
            }
        }
        catch (OpenRDFException e) {
            throw new SailException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasetImpl getABoxDataset(InferencerConnection rc) throws SailException {
        DatasetImpl ds = new DatasetImpl();
        CloseableIteration ci = rc.getContextIDs();
        try {
            while (ci.hasNext()) {
                Resource c = (Resource)ci.next();
                if (!(c instanceof URI) || tboxGraphs.contains((URI)c) || REPO.NG_INFERRED.equals((URI)c)) continue;
                ds.addDefaultGraph((URI)c);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Dataset for ABox query = " + Utils.prettyPrint((Dataset)ds)));
            }
        }
        finally {
            ci.close();
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInferredTypes(InferencerConnection rc, URI subject, URI assertedType) throws SailException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addInferredTypes subject=" + subject + ", asserted type=" + assertedType));
        }
        CloseableIteration sti = rc.getStatements((Resource)assertedType, RDFS.SUBCLASSOF, null, true, (Resource[])tboxGraphsAsArray);
        try {
            while (sti.hasNext()) {
                Statement sts = (Statement)sti.next();
                Value superType = sts.getObject();
                if (!(superType instanceof URI)) continue;
                URI[] tuple = new URI[]{subject, (URI)superType};
                if (this.inferredTypeBuffer.offer(tuple)) continue;
                this.flushInferredTypes(rc);
                if (this.inferredTypeBuffer.offer(tuple)) continue;
                this.log.error((Object)("Failed to enqueue inferred statement after flushing! subj = " + subject));
            }
        }
        finally {
            sti.close();
        }
    }

    private void flushInferredTypes(InferencerConnection rc) throws SailException {
        this.log.debug((Object)("Flushing inferred rdf:type statements, count=" + this.inferredTypeBuffer.size()));
        for (URI[] pair : this.inferredTypeBuffer) {
            if (!rc.addInferredStatement((Resource)pair[0], RDF.TYPE, (Value)pair[1], new Resource[]{REPO.NG_INFERRED})) continue;
            ++this.aboxCount;
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("rc.addInferredStatement(" + pair[0] + ", " + RDF.TYPE + ", " + pair[1] + ", " + REPO.NG_INFERRED + ")"));
        }
        this.inferredTypeBuffer.clear();
    }

    public void commit() throws SailException {
        super.commit();
        this.log.debug((Object)"Called commit()");
        if (this.inferredTypeBuffer.size() > 0) {
            this.log.error((Object)"There are uncommitted ABox changes!");
        }
    }
}

