/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.model.TransportRole;
import org.eaglei.repository.model.Transporter;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.HandlerBadRequest;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransportRole
implements Transporter {
    private static Logger log = LogManager.getLogger(TransportRole.class);

    public void authorizeExport(HttpServletRequest request) throws ServletException {
        if (Authentication.getAuthenticatedUsername((HttpServletRequest)request) == null) {
            throw new ForbiddenException("Export of roles requires an authenticated user login.");
        }
    }

    public void authorizeImport(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Import of roles requires administrator privileges.");
        }
    }

    public void doExport(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RDFWriter out = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            out.startRDF();
            for (Role r : Role.findAll((HttpServletRequest)request)) {
                if (r.isBuiltin()) continue;
                URI ru = r.getURI();
                String rus = ru.stringValue();
                String rc = r.getComment();
                String rl = r.getLabel();
                if (excludes.contains(rl) || excludes.contains(rus)) {
                    log.debug((Object)("SKIP ROLE because of exclude: " + r));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(rl) || includes.contains(rus)) {
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)ru, RDF.TYPE, (Value)REPO.ROLE, (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)ru, RDFS.LABEL, (Value)new LiteralImpl(r.getLabel()), (Resource)REPO.NG_INTERNAL));
                    if (rc == null) continue;
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)ru, RDFS.COMMENT, (Value)new LiteralImpl(rc), (Resource)REPO.NG_INTERNAL));
                    continue;
                }
                log.debug((Object)("SKIP ROLE because of include: " + r));
            }
            out.endRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void doImport(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, ImportExport.DuplicateArg duplicate, boolean transform, boolean ignoreACL) throws ServletException, IOException {
        try {
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, Role.ROLE_QUERY);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query to get IMPORTED ROLES (against internal memory repo) =\n\t" + Role.ROLE_QUERY));
            }
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(false);
            importRoleHandler ih = new importRoleHandler(request, includes, excludes, duplicate, transform);
            q.evaluate((TupleQueryResultHandler)ih);
            if (importRoleHandler.access$000((importRoleHandler)ih) == 0 && content.size(new Resource[0]) > 0L) {
                throw new BadRequestException("Invalid input: None of the statements in the input data are valid Role representations.");
            }
        }
        catch (HandlerBadRequest e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

