/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.TransportUser;
import org.eaglei.repository.model.Transporter;
import org.eaglei.repository.model.User;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.AppendingRDFHandler;
import org.eaglei.repository.util.HandlerBadRequest;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransportUser
implements Transporter {
    private static Logger log = LogManager.getLogger(TransportUser.class);
    private static final URI EXPORT_AUTH_PASSWORD = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthPassword");
    private static final URI EXPORT_AUTH_TYPE = new URIImpl("http://eagle-i.org/ont/repo/1.0/exportAuthType");
    private static final String importUserPass1Query = "SELECT DISTINCT ?subject ?username ?password ?userProp ?userPropValue WHERE { \n GRAPH <" + User.USER_GRAPH + "> { ?subject a <" + REPO.PERSON + "> }\n" + " GRAPH <" + REPO.NG_INTERNAL + "> { ?subject <" + REPO.HAS_PRINCIPAL_NAME + "> ?username}\n" + " OPTIONAL { GRAPH <" + User.USER_GRAPH + "> { ?subject ?userProp ?userPropValue }}\n" + " OPTIONAL { GRAPH <" + REPO.NG_INTERNAL + "> { ?subject <" + EXPORT_AUTH_PASSWORD + "> ?password }}}\n" + "ORDER BY ?subject";
    private static final String importUserPass2Query = "SELECT DISTINCT ?subject ?username ?role WHERE { \n GRAPH <" + User.USER_GRAPH + "> { ?subject a <" + REPO.PERSON + "> }\n" + " GRAPH <" + REPO.NG_INTERNAL + "> { ?subject <" + REPO.HAS_PRINCIPAL_NAME + "> ?username ; <" + REPO.HAS_ROLE + "> ?role}}\n" + "ORDER BY ?subject";

    public void authorizeExport(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Export of Users requires administrator privileges.");
        }
    }

    public void authorizeImport(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Import of Users requires administrator privileges.");
        }
    }

    public void doExport(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            AppendingRDFHandler out = new AppendingRDFHandler((RDFHandler)Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")));
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            out.startRDF();
            for (User u : User.findAll((HttpServletRequest)request)) {
                String uus;
                String un = u.getUsername();
                URI uu = u.getURI();
                String string = uus = uu == null ? null : uu.toString();
                if (excludes.contains(un) || uus != null && excludes.contains(uus)) {
                    log.debug((Object)("SKIP USER because of exclude: " + u));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(un) || uus != null && includes.contains(uus)) {
                    String pw;
                    URI subject = null;
                    if (uu == null) {
                        log.debug((Object)("EXPORT UNDOCUMENTED USER: \"" + un + "\""));
                        subject = vf.createBNode();
                        out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, RDF.TYPE, (Value)REPO.PERSON, (Resource)User.USER_GRAPH));
                        out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, REPO.HAS_PRINCIPAL_NAME, (Value)new LiteralImpl(un, XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                        if (u.isSuperuser()) {
                            out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, REPO.HAS_ROLE, (Value)REPO.ROLE_SUPERUSER, (Resource)REPO.NG_INTERNAL));
                        }
                    } else {
                        log.debug((Object)("EXPORT DOCUMENTED USER: " + uu));
                        subject = uu;
                        rc.exportStatements((Resource)uu, null, null, false, (RDFHandler)out, new Resource[]{User.USER_GRAPH, REPO.NG_INTERNAL});
                    }
                    if ((pw = u.getPassword()) == null) {
                        log.debug((Object)("User has no password or credentials: username=" + un));
                        continue;
                    }
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, EXPORT_AUTH_TYPE, (Value)u.getAuthType(), (Resource)REPO.NG_INTERNAL));
                    out.handleStatement((Statement)new ContextStatementImpl((Resource)subject, EXPORT_AUTH_PASSWORD, (Value)new LiteralImpl(pw, XMLSchema.STRING), (Resource)REPO.NG_INTERNAL));
                    continue;
                }
                log.debug((Object)("SKIP USER because of include: " + u));
            }
            out.reallyEndRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void doImport(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, ImportExport.DuplicateArg duplicate, boolean transform, boolean ignoreACL) throws ServletException, IOException {
        try {
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, importUserPass1Query);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query PASS1 against internal memory repo = " + importUserPass1Query));
            }
            q.setDataset((Dataset)User.USER_DATASET);
            q.setIncludeInferred(false);
            UserHandler uh = new UserHandler(request, transform, duplicate, includes, excludes);
            q.evaluate((TupleQueryResultHandler)uh);
            q = content.prepareTupleQuery(QueryLanguage.SPARQL, importUserPass2Query);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query PASS2 against internal memory repo = " + importUserPass2Query));
            }
            q.setDataset((Dataset)User.USER_DATASET);
            q.setIncludeInferred(false);
            q.evaluate((TupleQueryResultHandler)uh);
            User.commitMultiple((HttpServletRequest)request, UserHandler.access$000((UserHandler)uh).values());
        }
        catch (HandlerBadRequest e) {
            log.error((Object)"Failed in query result handler: ", (Throwable)e);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)"Failed in sesame: ", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

