/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.Utils;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.Rio;

public class SparqlProtocol
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(SparqlProtocol.class);
    private static final String P_QUERY = "query";
    private static final String P_NAMED_GRAPH = "named-graph-uri";
    private static final String P_DEFAULT_GRAPH = "default-graph-uri";
    private static long slowQuery = 0L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rawquery;
        long startMs;
        block38: {
            request.setCharacterEncoding("UTF-8");
            startMs = System.currentTimeMillis();
            rawquery = this.getParameter(request, P_QUERY, true);
            String[] namedGraph = this.getParameters(request, P_NAMED_GRAPH, false);
            String[] defaultGraph = this.getParameters(request, P_DEFAULT_GRAPH, false);
            String format = this.getParameter(request, "format", false);
            String rawview = this.getParameter(request, "view", false);
            String workspace = this.getParameter(request, "workspace", false);
            String time = this.getParameter(request, "time", false);
            boolean inferred = this.getParameterAsBoolean(request, "inferred", true, false);
            View view = null;
            if (rawview != null && rawview.length() > 0) {
                view = View.parseView((String)rawview);
            }
            if (workspace != null && workspace.length() == 0) {
                workspace = null;
            }
            int dsCount = 0;
            if (namedGraph != null || defaultGraph != null) {
                ++dsCount;
            }
            if (workspace != null) {
                ++dsCount;
            }
            if (view != null) {
                ++dsCount;
            }
            if (dsCount > 1) {
                throw new BadRequestException("Only one of the arguments for 'view', 'workspace' or explicit named/default graph URIs maybe specified.");
            }
            if (dsCount == 0) {
                throw new BadRequestException("Missing required argument: Exactly one of the arguments 'view', 'workspace' or explicit named/default graph URIs must be specified.");
            }
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            try {
                String mimeType;
                DatasetImpl ds = new DatasetImpl();
                if (defaultGraph != null || namedGraph != null) {
                    URI gu;
                    if (defaultGraph != null) {
                        for (String n : defaultGraph) {
                            gu = Utils.parseURI((String)n, (String)P_DEFAULT_GRAPH, (boolean)true);
                            if (!Access.hasPermission((HttpServletRequest)request, (Resource)gu, (Access)Access.READ)) throw new ForbiddenException("Read access denied to named graph: " + gu.toString());
                            log.debug((Object)("Adding Default Graph to the dataset: " + n));
                            ds.addDefaultGraph(gu);
                        }
                    }
                    if (namedGraph != null) {
                        for (String n : namedGraph) {
                            gu = Utils.parseURI((String)n, (String)P_NAMED_GRAPH, (boolean)true);
                            if (!Access.hasPermission((HttpServletRequest)request, (Resource)gu, (Access)Access.READ)) throw new ForbiddenException("Read access denied to named graph: " + gu.toString());
                            log.debug((Object)("Adding Named Graph to the dataset: " + n));
                            ds.addNamedGraph(gu);
                        }
                    }
                } else if (view != null) {
                    View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)view);
                } else if (workspace != null) {
                    View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)Utils.parseURI((String)workspace, (String)"workspace", (boolean)true));
                }
                if (ds.getDefaultGraphs().isEmpty() && ds.getNamedGraphs().isEmpty()) {
                    throw new InternalServerErrorException("Empty dataset for query, this should not happen.");
                }
                Query q = rc.prepareQuery(QueryLanguage.SPARQL, rawquery);
                q.setIncludeInferred(inferred);
                if (View.NULL.equals((Object)view)) {
                    log.debug((Object)"Null view, leave query's Dataset unset!");
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
                    }
                    q.setDataset((Dataset)ds);
                }
                if (time != null && time.length() > 0) {
                    try {
                        int tl = Integer.parseInt(time);
                        q.setMaxQueryTime(tl);
                        log.debug((Object)("Setting query time limit to " + String.valueOf(tl) + " seconds."));
                    }
                    catch (NumberFormatException e) {
                        throw new BadRequestException("Value for 'time' must be a decimal integer; this is unacceptable: " + time, (Throwable)e);
                    }
                }
                if (q instanceof TupleQuery) {
                    mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format);
                    TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
                    if (tqf == null) {
                        log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
                        throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
                    }
                    response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
                    ((TupleQuery)q).evaluate((TupleQueryResultHandler)QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream()));
                    break block38;
                }
                if (q instanceof BooleanQuery) {
                    mimeType = Formats.negotiateBooleanContent((HttpServletRequest)request, (String)format);
                    BooleanQueryResultFormat bf = BooleanQueryResultFormat.forMIMEType((String)mimeType);
                    if (bf == null) {
                        log.error((Object)("Failed to get boolean serialization format, for mime=" + mimeType));
                        throw new ServletException("Failed to get boolean serialization format that SHOULD have been available, for mime=" + mimeType);
                    }
                    response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
                    QueryResultIO.createWriter((BooleanQueryResultFormat)bf, (OutputStream)response.getOutputStream()).write(((BooleanQuery)q).evaluate());
                } else {
                    if (!(q instanceof GraphQuery)) {
                        log.error((Object)"Unrecognized query type! This should never happen.");
                        throw new BadRequestException("Unrecognized query type! This should never happen.");
                    }
                    mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)format);
                    RDFFormat rf = Formats.RDFOutputFormatForMIMEType((String)mimeType);
                    if (rf == null) {
                        log.error((Object)("Failed to get RDF serialization format, for mime=" + mimeType));
                        throw new ServletException("Failed to get RDF serialization format that SHOULD have been available, for mime=" + mimeType);
                    }
                    response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
                    ((GraphQuery)q).evaluate((RDFHandler)Rio.createWriter((RDFFormat)rf, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")));
                }
            }
            catch (MalformedQueryException e) {
                try {
                    log.info((Object)"Rejecting malformed query.");
                    throw new BadRequestException("Malformed query: " + e.toString(), (Throwable)e);
                    catch (UnsupportedOperationException e2) {
                        log.error((Object)e2);
                        throw new ServletException((Throwable)e2);
                    }
                    catch (OpenRDFException e3) {
                        log.error((Object)e3);
                        throw new ServletException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    long queryMs = System.currentTimeMillis() - startMs;
                    String qtrunc = rawquery;
                    Pattern qp = Pattern.compile("(select|ask|construct).*", 2);
                    Matcher qm = qp.matcher(rawquery);
                    if (qm.find()) {
                        qtrunc = rawquery.substring(qm.start());
                    }
                    log.info((Object)("SPARQL protocol request completed in " + String.format("%,d mSec. query=%.120s (...)", queryMs, qtrunc)));
                    if (slowQuery == 0L) throw throwable;
                    if (queryMs <= slowQuery) throw throwable;
                    log.info((Object)String.format("SLOW QUERY, time = %d.%03d sec, query =\n%s\n", queryMs / 1000L, queryMs % 1000L, rawquery));
                    throw throwable;
                }
            }
        }
        long queryMs = System.currentTimeMillis() - startMs;
        String qtrunc = rawquery;
        Pattern qp = Pattern.compile("(select|ask|construct).*", 2);
        Matcher qm = qp.matcher(rawquery);
        if (qm.find()) {
            qtrunc = rawquery.substring(qm.start());
        }
        log.info((Object)("SPARQL protocol request completed in " + String.format("%,d mSec. query=%.120s (...)", queryMs, qtrunc)));
        if (slowQuery == 0L) return;
        if (queryMs <= slowQuery) return;
        log.info((Object)String.format("SLOW QUERY, time = %d.%03d sec, query =\n%s\n", queryMs / 1000L, queryMs % 1000L, rawquery));
    }

    static {
        String sq = Configuration.getInstance().getConfigurationProperty("eaglei.repository.slow.query");
        try {
            if (sq != null) {
                slowQuery = 1000 * Integer.parseInt(sq);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Value of config property \"eaglei.repository.slow.query\" is not a legal Long integer: " + sq + ": exception=" + e));
        }
    }
}

