/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet.admin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;
import org.openrdf.model.URI;

public class UpdateNamedGraph
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(UpdateNamedGraph.class);
    private static final String[] PASS_THRU_ARGS = new String[0];

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        URI uri = this.getParameterAsURI(request, "uri", true);
        String label = this.getParameter(request, "label", false);
        URI type = this.getParameterAsURI(request, "type", false);
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("This service is only for use by administrators.");
        }
        NamedGraph ng = NamedGraph.find((HttpServletRequest)request, (URI)uri);
        if (ng == null) {
            throw new NotFoundException("This URI is not a named graph or managed context: " + uri.stringValue());
        }
        NamedGraphType ngt = null;
        if (type != null && (ngt = NamedGraphType.find((HttpServletRequest)request, (URI)type)) == null) {
            throw new BadRequestException("This type is not a URI of a Named Graph Type: " + type.stringValue());
        }
        ng.setLabel(request, label);
        ng.setType(request, ngt);
        ng.commit(request);
        this.redirectToJSP(request, response, "Modified the named graph metadata.", PASS_THRU_ARGS, new String[]{"uri", uri.stringValue()});
    }
}

