<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@ page import="java.io.Writer" %>
<%@ page import="java.io.StringWriter" %>
<%@ page import="java.io.PrintWriter" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%
    Logger log = LogManager.getLogger("org.eaglei.repository.admin.error.jsp");
    log.debug("Entering error.jsp");
    try {
        Object rawStatus_code = request.getAttribute("javax.servlet.error.status_code");
        String status_code =  rawStatus_code == null ? "(status not set)" : rawStatus_code.toString();
        String uri = (String)request.getAttribute("javax.servlet.error.request_uri");
        String message = (String)request.getAttribute("javax.servlet.error.message");
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (exception == null) {
            exception = (Throwable)request.getAttribute("org.eaglei.repository.error.exception");
        }
        if (message == null) {
            message = "STATUS "+status_code;
        }
        log.debug("status_code="+status_code+", uri="+uri+", msg="+message);
        // for internal failures, leave a record in server log too.
        if (status_code.equals("500")) {
            log.error("Request status is Internal Server Error, stack trace follows:", exception);
        }
%>
  <head>
    <title>Data Repository - Error <%= status_code %></title>
    <style>
<!--
H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;}
H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;}
H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;}
BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;}
B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;}
P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}
A {color : black;}
A.name {color : black;}
HR {color : #525D76;}
.show { display: block; }
.hide { display: none; }
      -->
    </style>
  </head>
  <body>
    <h1>Repository HTTP Status <%= status_code %> - <%= uri %></h1>
    <HR size="1" noshade="noshade"/>
    <p><b>type</b> Status report</p>
    <p>
      <b>Message</b>
      <u><%= uri %></u>
    </p>
    <p>
      <b>Description</b>
      <u><%= StringEscapeUtils.escapeHtml(message) %></u>
    </p>
    <p>
      <b>More Details</b>
      <button type="button"
              onClick=" var stackTrace = document.getElementById('stackTrace');
                        if (stackTrace.className == 'hide') {
                            stackTrace.className = 'show';
                            textContent = 'Hide Stack Trace';
                        } else {
                            stackTrace.className = 'hide';
                            textContent = 'Show Stack Trace';
                        } ">Show Stack Trace</button>
      </p>
    <div id="stackTrace" class="hide">
     <h3>Stack Trace</h3>
     <pre>
      <%
        String stackTrace = "(not available)";
        if (exception != null) {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            stackTrace = sw.toString();
        }
      %>
      <%= StringEscapeUtils.escapeHtml(stackTrace) %>
     </pre>
    <HR size="1" noshade="noshade"/>
  </body>
<%
    } catch (Throwable e) {
        log.error("Got exception during error.jsp processing, OH NOES:",e);
        System.err.println("Got exception during error.jsp processing, OH NOES: "+e);
    }
%>
</html>
