<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -
   - Roles Admin - present a list of users with 3 columns:
   -   1. Label (also a link to edit the role if allowable)
   -   2. description
   -   3. delete button
   -  Args:
   -   action=delete -- delete a role, uri must be specified
   -    (default action is just to list roles; create is done by edit page)
   -   uri - URI of role to act on
  --%>
<%@ page import="java.util.Collections" %>
<%@ page import="java.util.List" %>

<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.model.Role" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>

  <head>
    <%@ include file="../head.jsp" %>
    <title>Eagle-I Data Repository Admin - Manage Access Roles</title>
  </head>
<%
    request.setCharacterEncoding("UTF-8");
    // feedback message about status of any chosen operation
    String message = request.getParameter("message");
    boolean messageSuccess = true;

    if (!Authentication.isSuperuser(request))
        throw new ForbiddenException("This page is only for use by administrators.");

    try {
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Manage Access Roles</h2>

<%
        if (message != null) {
%>
    <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
    </h3>
<%
        }
%>
     <h3>&#x26ab; <a href="/repository/admin/editRole.jsp?create">
         Create a New Role</a>
     </h3>
    <h3>&#x26ab; Manage Existing Roles</h3>
    <!-- columns: label, comment, delete? -->
    <div style="margin: 0px 0px 0px 30px;">
    <table border="1">
    <tr>
      <th>Role</th>
      <th>Description</th>
      <th>Action</th>
    </tr>
<%
    List<Role> cr = Role.findAll(request);
    Collections.sort(cr);
    for (Role r : cr) {
        String uri = r.getURI().stringValue();
        String rc = r.getComment();
 %>
        <tr>
          <td>
<%
        if (r.isBuiltin()) {
 %>
                  <tt><%= StringEscapeUtils.escapeHtml(r.getLabel()) %></tt>
<%
        } else {
 %>
            <a href="/repository/admin/editRole.jsp?uri=<%= Utils.urlEncode(uri) %>">
                  <tt><%= StringEscapeUtils.escapeHtml(r.getLabel()) %></tt>
            </a>
<%
        }
 %>
          </td>
          <td>
            <%=  rc == null ? "&nbsp;" : StringEscapeUtils.escapeHtml(rc) %>
          </td>
          <td>
<%
        if (r.isBuiltin()) {
 %>
            <i>n/a</i>
<%
        } else {
            // be sure there are no single or double-quotes to screw up javascript
            String roleLabel = Utils.escapeHTMLAttribute(r.getLabel().replace("\"", "`").replace("'","`"));
 %>
    <form action="/repository/admin/updateRole" method="POST"
          onclick="javascript:return confirm('Are you SURE you want to delete Role &quot;<%= roleLabel %>&quot; ?  It CANNOT be un-done.')">
      <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri) %>"/>
      <input type="hidden" name="action" value="delete"/>
      <button name="submit" value="submit" type="submit">&#x2620 <i>Delete</i></button>
    </form>
<%
        }
 %>
          </td>
        </tr>
<%
    }
 %>
    </table>
    <i>Click on Role's label to edit its properties.  Builtin roles cannot be changed.</i>
    </div>
    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
