package org.eaglei.repository.format;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;

/**
 * Boilerplate for Sesame RDF writer registry.
 *
 * @author Larry Stone
 * Started May 10, 2010
 * @version $Id: $
 */
public class RDFContextNTriplesWriterFactory implements RDFWriterFactory
{
    /**
     * <p>getRDFFormat</p>
     *
     * @return a {@link org.openrdf.rio.RDFFormat} object.
     */
    public RDFFormat getRDFFormat()
    {
        return RDFContextNTriplesWriter.CONTEXT_NTRIPLES;
    }

    /** {@inheritDoc} */
    public RDFWriter getWriter(OutputStream out)
    {
        return new RDFContextNTriplesWriter(new OutputStreamWriter(out));
    }
    /**
     * <p>getWriter</p>
     *
     * @param out a {@link java.io.Writer} object.
     * @return a {@link org.openrdf.rio.RDFWriter} object.
     */
    public RDFWriter getWriter(Writer out)
    {
        return new RDFContextNTriplesWriter(out);
    }
}
