package org.eaglei.repository.model.workflow;

import javax.servlet.http.HttpServletRequest;

import org.openrdf.model.URI;
import org.openrdf.model.Value;

/**
 * This is a marker class.  Setting a WorkflowTransition's action to
 * an instance of ErrorAction indicates there was a problem instantiating
 * the true action -- in most cases, the reason will be recorded in the
 * "message" member.
 *
 * However, when /import reads transitions with bogus actions, the true
 * error message is lost (although it still appears in the log) because
 * the RDF representation of the transition only remembers the class of
 * ErrorAction, not its message.
 */
public class ErrorAction implements WorkflowAction
{
    private String message = null;

    /** Default Constructor */
    public ErrorAction()
    {
        super();
        message = "Unrecorded failure, probably failed to instantiate action class on import (see log).";
    }

    /** Constructor, with error message */
    public ErrorAction(String m)
    {
        super();
        message = m;
    }

    /** Getter for message */
    public String getMessage()
    {
        return message;
    }

    /** {@inheritDoc} */
    public void onTransition(HttpServletRequest request, URI resource, Value param)
        throws Exception
    {
    }
}
