package org.eaglei.repository.servlet;

import org.eaglei.repository.util.WithRepositoryConnection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.repository.RepositoryException;
import org.openrdf.model.URI;

import org.eaglei.repository.model.workflow.Workflow;

/**
 *
 * Args:
 *  uri - URI of the resource instance to release
 *
 * @author Larry Stone
 * @version $Id: $
 * Started October 25, 2010
 */
public class WorkflowRelease extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(WorkflowRelease.class);

    /** {@inheritDoc} */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        URI uri = getParameterAsURI(request, "uri", true);

        // this will fail if resource isn't visible to current user
        Workflow wf = Workflow.find(request, uri);

        // this tests for no existing claim, and access to a transition
        wf.releaseClaim(request);
        try {
            WithRepositoryConnection.get(request).commit();
        } catch (RepositoryException e) {
            throw new ServletException(e);
        }
    }
}
