#!/bin/sh

# simple script to load ontology RDF
#
# WARNING: This is only intended to be used for testing and debugging, it is
#  NOT an official part of the repository.  However, there is not yet any
#  better way to load ontologies.  Use it at your own risk.
#
# It is hardwired to look for the jar created by the eagle-i-model-owl
# maven package, since this is our current (28-Apr-10) convention.
# It then grabs all the files with a ".owl" extension from that jar and
# loads them into one named graph.
#
# Usage:
#  Two modes: show with required args:
#
#  1. Load all data model ontologies:
#    -a  [WAR-file]  [user] [password] [repository-URL]
#
#  2. load a single ontology file into named graph
#    -s  [path/URL]  [user] [password] [repository-URL]
#
#  example: load-ontology  /opt/tomcat/ROOT.war  admin password http://localhost:8008/
#
# BUGS:
#  - should be smarter about generating URIs for file uploads
#  - assumes all OWL content is RDF/XML by default, should check extension at least.
#  - doesn't interpret OWL 'imports' statements

set -e

#-------------- Configuration - may need to change these:

# path of model-owl jar within WAR:
dataModelPath='WEB-INF/lib/eagle-i-model-owl-[0-9].[0-9].[0-9]*.jar'

# name of graph for data model ontology
dataModelGraph='http://purl.obolibrary.org/obo/ero.owl'

#-------------- End Configuration

Usage="Usage:  $0   -a  [WAR-file]  [user] [password] [repository-URL]"

# load all from war
if [ "$1" = '-a' ]; then
  warpath=$2
  user=$3
  password=$4
  repo=$5
  if [ -z "$repo" ]; then
    echo 'Missing required arguments for -a'
    echo $Usage
    exit 1
  fi

  # get jar with ontologies
  tmpjar=/tmp/ei-model-owl-tmp-$$.jar
  tmpout=/tmp/onto-load-out-$$.txt

  if  unzip -qjp $warpath "$dataModelPath" > $tmpjar ; then

    echo "\nINFO: Loading OWL into named graph = ${dataModelGraph}"

    # clear out the named graph
    curl -s -S -u "${user}:${password}" -F 'action=replace' \
    -F "name=${dataModelGraph}" -F type=ontology \
    --write-out '\nCleared ontology graph: status=%{http_code}, time=%{time_total}\n' \
      -F 'content=@/dev/null;type=text/rdf+n3' "${repo}/repository/graph" > $tmpout

    # check HTTP status
    if egrep -q 'status=20[01],' $tmpout ; then
        cat "$tmpout"
        rm "$tmpout"
    else
        echo "FAILED clearing ontology graph\n\n"
        cat "$tmpout"
        rm "$tmpout"
        exit 1
    fi

    exitStatus=0

    # for each OWL file, add it to ontology named graph
    for owlpath in `jar tf $tmpjar | egrep '\.owl$'` ; do
      unzip -qjp $tmpjar "$owlpath" >shit.owl ; \
      curl -s -S -u "${user}:${password}" -F 'action=add' <shit.owl \
        -F "name=${dataModelGraph}" -F type=ontology \
        --write-out "\\nAdd ${owlpath} to ontology graph: status=%{http_code}, time=%{time_total}, %{size_upload} bytes\\n" \
        -F 'content=<-;type=application/rdf+xml' "${repo}/repository/graph" > $tmpout
         
        # check HTTP status
        if egrep -q 'status=20[01],' $tmpout ; then
            cat "$tmpout"
            rm "$tmpout"
        else
            echo "FAILED uploading ontology file: ${owlpath}\n\n"
            cat "$tmpout"
            rm "$tmpout"
            failed="${failed}\n\t${owlpath}"
            exitStatus=1
        fi
    done
    rm -f "$tmpjar"
    if [ -n "$failed" ]; then
        dmFile=`unzip -lq $warpath "$dataModelPath" |awk 'FNR == 3 {print $4}'`
        echo "\nERROR: THE FOLLOWING FILES FAILED\nERROR: in ${dmFile} extracted from ${warpath}\n${failed}"
    fi
    exit $exitStatus

  else
    echo "Failed to extract OWL jar from WAR file: $warpath"
    exit 1
  fi

elif [ "$1" = "-s" ]; then
    echo "Single load not implemented."
    exit 1

else
    echo "$Usage"
    exit 1
fi
