/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.BadRequestException;
import org.eaglei.repository.DataRepositoryLifecycle;
import org.eaglei.repository.ForbiddenException;
import org.eaglei.repository.InternalServerErrorException;
import org.eaglei.repository.REPO;
import org.eaglei.repository.Role;
import org.eaglei.repository.SPARQL;
import org.eaglei.repository.User;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Access {
    READ(REPO.HAS_READ_ACCESS),
    ADD(REPO.HAS_ADD_ACCESS),
    REMOVE(REPO.HAS_REMOVE_ACCESS),
    ADMIN(REPO.HAS_ADMIN_ACCESS);

    private URI uri = null;
    private static final String S_USER = "org.eaglei.repository.Access.User";
    private static final String S_REMOTE_IP = "org.eaglei.repository.Access.REMOTE_IP";
    private static Logger log;
    private static final String hasPermissionQuery;
    private static String getGrantsQuery;
    private static final String allRolesQuery;
    private static final String allAccessesQuery;

    private Access(String uri) {
        this.uri = new URIImpl(uri);
    }

    private Access(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public static boolean hasPermission(HttpServletRequest request, Resource subject, URI type, Access pred) {
        if (Access.isSuperuser((HttpServletRequest)request)) {
            log.debug((Object)("Superuser elides check: hasPermission(" + subject + ", " + pred + ") => true"));
            return true;
        }
        try {
            URI pu = Access.getPrincipalURI((HttpServletRequest)request);
            RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
            BooleanQuery q = rc.prepareBooleanQuery(QueryLanguage.SPARQL, hasPermissionQuery);
            q.setIncludeInferred(true);
            q.setDataset((Dataset)SPARQL.InternalGraphsAndInferred);
            q.clearBindings();
            q.setBinding("user", (Value)pu);
            q.setBinding("access", (Value)pred.uri);
            q.setBinding("resource", (Value)subject);
            boolean result = q.evaluate();
            log.debug((Object)("hasPermission(" + subject + ", " + pred + ", " + pu + ") => " + result));
            return result;
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in access check: ", (Throwable)e);
        }
    }

    public static boolean hasPermissionOnUser(HttpServletRequest request, String username) {
        Principal p = request.getUserPrincipal();
        return Access.isSuperuser((HttpServletRequest)request) || username != null && p != null && username.equals(p.getName());
    }

    public static void filterByPermission(HttpServletRequest request, String name, String patternGroup, Access pred, TupleQueryResultHandler handler2) {
        try {
            URI pu = Access.getPrincipalURI((HttpServletRequest)request);
            RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
            String qs = Access.makeAccessQuery((String)name, (String)("SELECT ?" + name + " WHERE"), (String)patternGroup);
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setIncludeInferred(true);
            q.setDataset((Dataset)SPARQL.InternalGraphsAndInferred);
            q.clearBindings();
            q.setBinding("user", (Value)pu);
            q.setBinding("access", (Value)pred.uri);
            q.evaluate(handler2);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in access check: ", (Throwable)e);
        }
    }

    public static URI getPrincipalURI(HttpServletRequest request) {
        User u = Access.getPrincipalUser((HttpServletRequest)request);
        if (u == null) {
            log.debug((Object)"getPrincipalURI: Returning :Anonymous for unauthenticated user.");
            return REPO.ROLE_ANONYMOUS;
        }
        return u.getURI();
    }

    public static void decacheUser(HttpServletRequest request, User u) {
        HttpSession session = Access.getValidatedSession((HttpServletRequest)request);
        User cu = (User)session.getAttribute("org.eaglei.repository.Access.User");
        if (cu != null && cu.equals((Object)u)) {
            session.removeAttribute("org.eaglei.repository.Access.User");
        }
    }

    private static synchronized User getPrincipalUser(HttpServletRequest request) {
        Principal p = request.getUserPrincipal();
        if (p == null) {
            return null;
        }
        String pname = p.getName();
        HttpSession session = Access.getValidatedSession((HttpServletRequest)request);
        if (DataRepositoryLifecycle.isSessionStale((HttpSession)session)) {
            session.removeAttribute("org.eaglei.repository.Access.User");
            log.debug((Object)("Invalidating cached user URI in stale session, principal=" + pname));
        } else {
            User result = (User)session.getAttribute("org.eaglei.repository.Access.User");
            if (result != null) {
                log.debug((Object)("Returning cached user for principal=" + pname + " from session context: " + result));
                return result;
            }
        }
        try {
            User u = User.findUsername((HttpServletRequest)request, (String)pname);
            if (u != null) {
                if (!u.hasRoleP(REPO.ROLE_SUPERUSER) && request.isUserInRole("superuser")) {
                    u.addRole(request, Role.find((HttpServletRequest)request, (URI)REPO.ROLE_SUPERUSER), true);
                }
                session.setAttribute("org.eaglei.repository.Access.User", (Object)u);
                return u;
            }
            u = User.create((HttpServletRequest)request, (String)pname, (boolean)true);
            if (request.isUserInRole("superuser")) {
                u.addRole(request, Role.find((HttpServletRequest)request, (URI)REPO.ROLE_SUPERUSER), true);
            }
            u.update(request);
            session.setAttribute("org.eaglei.repository.Access.User", (Object)u);
            log.info((Object)("Login created new User for principal=" + pname + ", as User=" + u.toString()));
            return u;
        }
        catch (ServletException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isSuperuser(HttpServletRequest request) {
        User u = Access.getPrincipalUser((HttpServletRequest)request);
        if (u == null) {
            return false;
        }
        return u.hasRoleP(REPO.ROLE_SUPERUSER);
    }

    private static HttpSession getValidatedSession(HttpServletRequest request) {
        HttpSession result = request.getSession(false);
        String remoteIP = request.getRemoteAddr();
        if (result == null) {
            result = request.getSession(true);
            result.setAttribute("org.eaglei.repository.Access.REMOTE_IP", (Object)remoteIP);
        } else {
            String testIP = (String)result.getAttribute("org.eaglei.repository.Access.REMOTE_IP");
            if (testIP == null) {
                log.debug((Object)("Initializing session's record of remote address, IP=" + remoteIP));
                result.setAttribute("org.eaglei.repository.Access.REMOTE_IP", (Object)remoteIP);
            } else if (!testIP.equals(remoteIP)) {
                log.error((Object)("POSSIBLE SESSION HIJACKING: session created by IP=" + testIP + ", but is being accessed by IP=" + remoteIP));
                throw new BadRequestException("Authentication denied, this session may only be accessed from the address that created it. Please login again.");
            }
        }
        return result;
    }

    public static void logout(HttpServletRequest request) {
        HttpSession s = request.getSession(false);
        if (s == null) {
            log.debug((Object)"Logout finds no session to destroy!");
        } else {
            s.invalidate();
            log.debug((Object)("Logout is destroying session ID=" + s.getId()));
        }
    }

    private static String makeAccessQuery(String resourceName, String prologue, String patternGroup) {
        StringBuilder result = new StringBuilder();
        result.append(prologue).append(" { ");
        if (patternGroup != null) {
            result.append(patternGroup);
        }
        result.append("{ { ?user <").append(REPO.HAS_ROLE).append("> ?r . ?r a ?ar . ?").append(resourceName).append(" ?access ?ar }\n");
        result.append(" UNION { ?user a <").append(REPO.PERSON).append("> . ?").append(resourceName).append(" ?access ?ar . <").append(REPO.ROLE_AUTHENTICATED).append("> a ?ar }\n");
        result.append(" UNION { ?").append(resourceName).append(" ?access ?user } } }");
        return result.toString();
    }

    public static boolean removeGrant(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (instance == null || access == null || agent == null) {
            throw new BadRequestException("removeGrant called with an illegal null URI.");
        }
        if (Access.hasPermission((HttpServletRequest)request, (Resource)instance, null, (Access)ADMIN)) {
            RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
            try {
                if (rc.hasStatement((Resource)instance, access, (Value)agent, false, new Resource[]{REPO.NG_INTERNAL})) {
                    rc.remove((Resource)instance, access, (Value)agent, new Resource[]{REPO.NG_INTERNAL});
                    return true;
                }
                return false;
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new InternalServerErrorException("Failed in remove ACL: ", (Throwable)e);
            }
        }
        throw new ForbiddenException("You are not allowed to change access controls on " + instance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addGrant(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (!Access.hasPermission((HttpServletRequest)request, (Resource)instance, null, (Access)ADMIN)) throw new ForbiddenException("You are not allowed to change access controls on " + instance);
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        try {
            if (rc.hasStatement((Resource)instance, access, (Value)agent, false, new Resource[]{REPO.NG_INTERNAL})) return;
            rc.add((Resource)instance, access, (Value)agent, new Resource[]{REPO.NG_INTERNAL});
            return;
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in add ACL: ", (Throwable)e);
        }
    }

    public static Iterable<Grant> getGrants(HttpServletRequest request, URI uri) {
        if (getGrantsQuery == null) {
            StringBuilder sb = new StringBuilder("SELECT DISTINCT * WHERE { \n?instance ?access ?agent \nOPTIONAL { ?access <" + RDFS.LABEL + "> ?accessLabel }\n" + "OPTIONAL { ?agent <" + RDFS.LABEL + "> ?agentLabel }\n" + "OPTIONAL { ?agent <" + RDF.TYPE + "> ?agentType FILTER (?agentType = <" + REPO.ROLE + "> || ?agentType = <" + REPO.PERSON + ">) \n" + "  OPTIONAL { ?agentType <" + RDFS.LABEL + "> ?agentTypeLabel }}\n" + "FILTER(");
            boolean first = true;
            for (Term a : Access.getAllAccesses((HttpServletRequest)request)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" || ");
                }
                sb.append("?access = <").append(a.toString()).append(">");
            }
            sb.append(")}");
            getGrantsQuery = sb.toString();
            log.debug((Object)("Initializing getGrantsQuery = " + getGrantsQuery));
        }
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        try {
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, getGrantsQuery);
            q.setBinding("instance", (Value)uri);
            q.setDataset((Dataset)SPARQL.InternalGraphsAndInferred);
            grantHandler h = new grantHandler(rc, uri);
            q.evaluate((TupleQueryResultHandler)h);
            return grantHandler.access$000((grantHandler)h);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query: ", (Throwable)e);
        }
    }

    public static Iterable<Term> getAllRoles(HttpServletRequest request) {
        log.debug((Object)("getAllRolees query = " + allRolesQuery));
        return Access.getAllTermsInternal((HttpServletRequest)request, (String)allRolesQuery);
    }

    public static Iterable<Term> getAllAccesses(HttpServletRequest request) {
        log.debug((Object)("getAllAccesses query = " + allAccessesQuery));
        return Access.getAllTermsInternal((HttpServletRequest)request, (String)allAccessesQuery);
    }

    private static Iterable<Term> getAllTermsInternal(HttpServletRequest request, String query) {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        try {
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query);
            q.setDataset((Dataset)SPARQL.InternalGraphsAndInferred);
            termHandler h = new termHandler(null);
            q.evaluate((TupleQueryResultHandler)h);
            return termHandler.access$200((termHandler)h);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query: ", (Throwable)e);
        }
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static {
        log = LogManager.getLogger(Access.class);
        hasPermissionQuery = Access.makeAccessQuery((String)"resource", (String)"ASK", null);
        getGrantsQuery = null;
        allRolesQuery = "SELECT DISTINCT * WHERE { ?uri <" + RDFS.SUBCLASSOF + "> <" + REPO.ROLE + ">\n" + " OPTIONAL { ?uri <" + RDFS.LABEL + "> ?label } \n" + " FILTER( ?uri != <" + REPO.ROLE + "> && ?uri != <" + REPO.ROLE_SUPERUSER + "> ) }";
        allAccessesQuery = "SELECT DISTINCT * WHERE { ?uri a <" + OWL.OBJECTPROPERTY + "> ;\n" + "  <" + RDFS.RANGE + "> <" + REPO.AGENT + ">\n" + " OPTIONAL { ?uri <" + RDFS.LABEL + "> ?label } \n" + " FILTER(regex(str(?uri), '/has.*Access$')) }";
    }
}

