/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.NotAcceptableException;
import org.eaglei.repository.format.RDFNQuadsWriterFactory;
import org.eaglei.repository.format.SPARQLHTMLWriterFactory;
import org.eaglei.repository.format.SPARQLTextWriterFactory;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

/*
 * Exception performing whole class analysis ignored.
 */
public class Formats {
    private static Logger log = LogManager.getLogger(Formats.class);
    public static final String DEFAULT_RDF_MIMETYPE = "application/rdf+xml";
    public static final String DEFAULT_BOOLEAN_MIMETYPE = "application/sparql-results+xml";
    public static final String DEFAULT_TUPLE_MIMETYPE = "application/sparql-results+xml";
    private static Set<String> mtRDF = new HashSet();
    private static RDFWriterRegistry RDFWregistry = RDFWriterRegistry.getInstance();
    private static Set<String> mtTuple;
    private static Set<String> mtBoolean;

    public static String negotiateRDFContent(HttpServletRequest request, String format, String dflt) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, (Collection)mtRDF, (String)dflt);
    }

    public static String negotiateTupleContent(HttpServletRequest request, String format, String dflt) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, (Collection)mtTuple, (String)dflt);
    }

    public static String negotiateBooleanContent(HttpServletRequest request, String format, String dflt) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, (Collection)mtBoolean, (String)dflt);
    }

    private static String negotiateContent(HttpServletRequest request, String format, Collection<String> formats, String dflt) {
        String accept = request.getHeader("Accept");
        if (format != null) {
            if (formats.contains(format)) {
                return format;
            }
            throw new NotAcceptableException("The demanded response format is not available: " + format);
        }
        if (accept != null) {
            for (String a : accept.trim().split("\\s*,\\s*")) {
                int semi = a.indexOf(";");
                if (semi >= 0) {
                    a = a.substring(0, semi).trim();
                }
                log.debug((Object)("Trying accept format mime=" + a));
                if (!formats.contains(a)) continue;
                return a;
            }
        } else if (dflt != null) {
            return dflt;
        }
        throw new NotAcceptableException("None of the available response formats is acceptable, and there is no default.");
    }

    public static RDFFormat RDFOutputFormatForMIMEType(String mime) {
        return (RDFFormat)RDFWregistry.getFileFormatForMIMEType(mime);
    }

    static {
        RDFWregistry.add((Object)new RDFNQuadsWriterFactory());
        for (RDFWriterFactory w : RDFWregistry.getAll()) {
            RDFFormat rf = w.getRDFFormat();
            for (String mt : rf.getMIMETypes()) {
                mtRDF.add(mt);
                log.debug((Object)("Adding RDF Serialization: mime=" + mt + ", format=" + rf));
            }
        }
        mtTuple = new HashSet();
        TupleQueryResultWriterRegistry registry = TupleQueryResultWriterRegistry.getInstance();
        registry.add((Object)new SPARQLTextWriterFactory());
        registry.add((Object)new SPARQLHTMLWriterFactory());
        for (TupleQueryResultWriterFactory w : registry.getAll()) {
            TupleQueryResultFormat tf = w.getTupleQueryResultFormat();
            for (String mt : tf.getMIMETypes()) {
                mtTuple.add(mt);
                log.debug((Object)("Adding Tuple serialization: mime=" + mt + ", format=" + tf));
            }
        }
        mtBoolean = new HashSet();
        for (BooleanQueryResultFormat bff : BooleanQueryResultFormat.SPARQL.values()) {
            for (String mt : bff.getMIMETypes()) {
                mtBoolean.add(mt);
                log.debug((Object)("Adding Boolean serialization: mime=" + mt + ", format=" + bff));
            }
        }
    }
}

