/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.BadRequestException;
import org.eaglei.repository.DataRepositoryLifecycle;
import org.eaglei.repository.FOAF;
import org.eaglei.repository.ForbiddenException;
import org.eaglei.repository.ID;
import org.eaglei.repository.REPO;
import org.eaglei.repository.Role;
import org.eaglei.repository.SPARQL;
import org.eaglei.repository.User;
import org.eaglei.repository.Utils;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
public class User {
    private static Logger log = LogManager.getLogger(User.class);
    private static final URI USER_GRAPH = REPO.NG_USERS;
    private static DatasetImpl userDataset = new DatasetImpl();
    private URI uri;
    private String username;
    private String firstName = null;
    private String lastName = null;
    private String mbox = null;
    private Set<Role> roles = new HashSet();
    private boolean dirty = false;
    private static final String userForURIQuery;

    private User(URI uri, String username) {
        this.uri = uri;
        this.username = username;
    }

    private void load(RepositoryConnection rc) throws ServletException {
        try {
            log.debug((Object)("Single user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)userDataset);
            q.clearBindings();
            if (this.uri != null) {
                q.setBinding("uri", (Value)this.uri);
            } else if (this.username != null) {
                q.setBinding("hasPrincipalName", (Value)new LiteralImpl(this.username));
            } else {
                throw new ServletException("Cannot load repository user description, because neither URI nor username was given.");
            }
            q.setIncludeInferred(false);
            q.evaluate((TupleQueryResultHandler)new oneUserHandler(this));
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static User find(HttpServletRequest request, URI uri) throws ServletException {
        User result = new User(uri, null);
        result.load((RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection"));
        log.debug((Object)("User.find(" + uri.stringValue() + ") => " + result));
        return result;
    }

    public static User findUsername(HttpServletRequest request, String pname) throws ServletException {
        User result = new User(null, pname);
        result.load((RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection"));
        log.debug((Object)("User.findUsername(" + pname + ") => " + result));
        return result.uri == null ? null : result;
    }

    public static Iterable<User> findAll(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        ArrayList<User> result = new ArrayList<User>();
        try {
            log.debug((Object)("All user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)userDataset);
            q.setIncludeInferred(false);
            q.evaluate((TupleQueryResultHandler)new allUserHandler(result));
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        return result;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getMbox() {
        return this.mbox;
    }

    public String getLabel() {
        if (this.firstName != null || this.lastName != null) {
            return this.firstName == null ? this.lastName : (this.lastName == null ? this.firstName : this.firstName + " " + this.lastName);
        }
        if (this.username != null) {
            return this.username;
        }
        return this.uri.getLocalName();
    }

    public Role[] getRoles() {
        return this.roles.toArray(new Role[this.roles.size()]);
    }

    public boolean hasRoleP(Role r) {
        return this.roles.contains(r);
    }

    public boolean hasRoleP(URI ru) {
        for (Role r : this.roles) {
            if (!r.getURI().equals(ru)) continue;
            return true;
        }
        return false;
    }

    public static User create(HttpServletRequest request, String username) throws ServletException {
        return User.create((HttpServletRequest)request, (String)username, (boolean)false);
    }

    public static User create(HttpServletRequest request, String username, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.hasPermissionOnUser((HttpServletRequest)request, (String)username)) {
            throw new ForbiddenException("Not allowed to create user: " + username);
        }
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        ValueFactory vf = rc.getValueFactory();
        User result = new User(null, username);
        try {
            Literal lpname = vf.createLiteral(username);
            if (rc.hasStatement(null, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, false, new Resource[0])) {
                throw new BadRequestException("Cannot create user: there is already a repository user with the login principal name (username) \"" + username + "\"");
            }
            result.uri = vf.createURI(DataRepositoryLifecycle.getDefaultNamespace(), ID.newID());
            rc.add((Resource)result.uri, RDF.TYPE, (Value)REPO.PERSON, new Resource[]{USER_GRAPH});
            rc.add((Resource)result.uri, RDFS.LABEL, (Value)lpname, new Resource[]{USER_GRAPH});
            rc.add((Resource)result.uri, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, new Resource[]{REPO.NG_INTERNAL});
            log.debug((Object)("create: created new User instance, username=" + username + ", uri=" + result.uri));
            result.dirty = true;
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating user URI: ", (Throwable)e);
            throw new ServletException("Failed creating user URI: ", (Throwable)e);
        }
    }

    public void setFirstName(HttpServletRequest request, String name) throws ServletException {
        this.setMetadataInternal(request, FOAF.FIRST_NAME, name);
        this.firstName = name;
    }

    public void setLastName(HttpServletRequest request, String name) throws ServletException {
        this.setMetadataInternal(request, FOAF.SURNAME, name);
        this.lastName = name;
    }

    public void setMbox(HttpServletRequest request, String mbox) throws ServletException {
        this.setMetadataInternal(request, FOAF.MBOX, mbox);
        this.mbox = mbox;
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, String newVal) throws ServletException {
        if (!Access.hasPermissionOnUser((HttpServletRequest)request, (String)this.username)) {
            throw new ForbiddenException("Not allowed to modify user: " + this.username);
        }
        try {
            RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
            boolean hasProp = rc.hasStatement((Resource)this.uri, property, null, false, new Resource[]{USER_GRAPH});
            ValueFactory vf = rc.getValueFactory();
            if (hasProp) {
                rc.remove((Resource)this.uri, property, null, new Resource[]{USER_GRAPH});
            }
            if (newVal != null) {
                rc.add((Resource)this.uri, property, (Value)vf.createLiteral(newVal), new Resource[]{USER_GRAPH});
            }
            this.dirty = true;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addRole(HttpServletRequest request, URI ru) throws ServletException {
        this.addRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void addRole(HttpServletRequest request, Role r) throws ServletException {
        this.addRole(request, r, false);
    }

    public void addRole(HttpServletRequest request, Role r, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        try {
            if (this.roles.add(r)) {
                rc.add((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[]{REPO.NG_INTERNAL});
                this.dirty = true;
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed adding role ", (Throwable)e);
        }
    }

    public void removeRole(HttpServletRequest request, URI ru) throws ServletException {
        this.removeRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void removeRole(HttpServletRequest request, Role r) throws ServletException {
        if (!Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (!this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        try {
            rc.remove((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[0]);
            this.roles.remove(r);
            this.dirty = true;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed removing role ", (Throwable)e);
        }
    }

    public void update(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        try {
            if (this.dirty) {
                String label = this.username;
                if (this.firstName != null || this.lastName != null) {
                    label = (this.firstName == null ? "" : this.firstName) + " " + (this.lastName == null ? "" : this.lastName);
                }
                log.debug((Object)("Setting User label, uri=" + this.uri + ", label=" + label));
                this.setMetadataInternal(request, RDFS.LABEL, label.trim());
                rc.commit();
                Access.decacheUser((HttpServletRequest)request, (User)this);
            }
            this.dirty = false;
        }
        catch (RepositoryException e) {
            log.error((Object)("Failed updating user, URI=" + this.uri), (Throwable)e);
            throw new ServletException("Failed updating user, URI=" + this.uri, (Throwable)e);
        }
    }

    protected void finalize() {
        if (this.dirty) {
            log.error((Object)("finalize: about to destroy a User with dirty flag set, CHANGES WILL BE LOST.  Current state: " + this.toString()));
        }
    }

    public String toString() {
        String rs = this.roles == null ? "{null}" : Arrays.deepToString(this.getRoles());
        String uu = this.uri == null ? "(not set)" : this.uri.toString();
        return "<#User: uri=" + uu + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", mbox=" + this.mbox + ", roles=" + rs + ">";
    }

    public boolean equals(Object o) {
        return o instanceof User && this.uri != null && this.uri.equals(((User)o).uri);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ URI access$100(User x0) {
        return x0.uri;
    }

    static /* synthetic */ URI access$102(User x0, URI x1) {
        x0.uri = x1;
        return x0.uri;
    }

    static /* synthetic */ String access$200(User x0) {
        return x0.username;
    }

    static /* synthetic */ String access$202(User x0, String x1) {
        x0.username = x1;
        return x0.username;
    }

    static /* synthetic */ String access$302(User x0, String x1) {
        x0.firstName = x1;
        return x0.firstName;
    }

    static /* synthetic */ String access$402(User x0, String x1) {
        x0.lastName = x1;
        return x0.lastName;
    }

    static /* synthetic */ String access$502(User x0, String x1) {
        x0.mbox = x1;
        return x0.mbox;
    }

    static /* synthetic */ Set access$600(User x0) {
        return x0.roles;
    }

    static {
        for (URI dg : SPARQL.InternalGraphs.getDefaultGraphs()) {
            userDataset.addDefaultGraph(dg);
        }
        userDataset.addDefaultGraph(USER_GRAPH);
        log.debug((Object)("User Dataset = " + Utils.prettyPrint((Dataset)userDataset)));
        userForURIQuery = "SELECT * WHERE { ?uri a <" + REPO.PERSON + "> ; \n" + "<" + REPO.HAS_PRINCIPAL_NAME + "> ?hasPrincipalName .\n" + "  OPTIONAL { ?uri <" + FOAF.FIRST_NAME + "> ?firstName }\n" + "  OPTIONAL { ?uri <" + FOAF.SURNAME + "> ?surname }\n" + "  OPTIONAL { ?uri <" + FOAF.MBOX + "> ?mbox }\n" + "  OPTIONAL { ?uri <" + REPO.HAS_ROLE + "> ?hasRole . ?hasRole <" + RDFS.LABEL + "> ?roleLabel }\n" + " } ORDER BY ?uri";
    }
}

