/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Dataset;

public class Utils {
    private static Logger log = LogManager.getLogger(Utils.class);
    private static final String SYS_HOME = "org.eaglei.repository.home";

    public static File getHomeDirectory() throws IOException {
        String home = System.getProperty(SYS_HOME);
        File result = null;
        boolean haveSysProp = home != null;
        result = !haveSysProp ? new File(System.getProperty("user.home"), "eaglei" + File.separator + "repository") : new File(home);
        if (!result.exists() && !result.mkdirs()) {
            log.fatal((Object)("The configured home directory does not exist: " + result.toString()));
            throw new IOException("The configured home directory does not exist: " + result.toString());
        }
        if (!result.isDirectory()) {
            log.fatal((Object)("The configured home directory is not a directory or is protected: " + result.toString()));
            throw new IOException("The configured home directory is not a directory or is protected: " + result.toString());
        }
        log.debug((Object)("repository home directory = " + result.toString()));
        if (!haveSysProp) {
            System.setProperty(SYS_HOME, result.toString());
        }
        return result;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static String prettyPrint(Dataset ds) {
        StringBuilder result = new StringBuilder();
        for (URI u : ds.getDefaultGraphs()) {
            result.append("FROM ").append(u == null ? "{null}" : "<" + u.toString() + ">").append("\n");
        }
        for (URI u : ds.getNamedGraphs()) {
            result.append("FROM NAMED ").append(u == null ? "{null}" : "<" + u.toString() + ">").append("\n");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static boolean isValidURI(String s) {
        try {
            new URIImpl(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

