/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.ForbiddenException;
import org.eaglei.repository.InternalServerErrorException;
import org.eaglei.repository.REPO;
import org.eaglei.repository.SPARQL;
import org.eaglei.repository.Views;
import org.openrdf.OpenRDFException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public class Views {
    private static Logger log = LogManager.getLogger(Views.class);

    public static void addGraphs(HttpServletRequest request, DatasetImpl ds, String viewName) {
        View vw = View.parseView((String)viewName);
        if (vw == null) {
            throw new IllegalArgumentException("Unknown view name: " + viewName);
        }
        Views.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)vw);
    }

    public static void addGraphs(HttpServletRequest request, DatasetImpl ds, View vw) {
        boolean testPermission = true;
        boolean filterByPermission = false;
        String pattern = null;
        switch (1.$SwitchMap$org$eaglei$repository$Views$View[vw.ordinal()]) {
            case 1: {
                pattern = "; <" + REPO.NG_TYPE + "> <" + REPO.NGTYPE_METADATA + "> ." + "filter( ?name != <" + REPO.NG_INTERNAL + "> )";
                filterByPermission = true;
                break;
            }
            case 2: {
                pattern = "; <" + REPO.NG_TYPE + "> <" + REPO.NGTYPE_ONTOLOGY + ">";
                filterByPermission = true;
                break;
            }
            case 3: {
                pattern = "; <" + REPO.NG_TYPE + "> ?ngt ." + "filter( (?ngt = <" + REPO.NGTYPE_ONTOLOGY + "> || " + " ?ngt = <" + REPO.NGTYPE_METADATA + ">) && " + "?name != <" + REPO.NG_INTERNAL + "> )";
                filterByPermission = true;
                break;
            }
            case 4: {
                pattern = "";
                filterByPermission = true;
                break;
            }
            case 5: {
                pattern = "; <" + REPO.NG_TYPE + "> ?ngt ." + "filter( ?ngt = <" + REPO.NGTYPE_ONTOLOGY + "> || " + "?ngt = <" + REPO.NGTYPE_METADATA + "> || " + "?name = <" + REPO.NG_PUBLISHED + "> )";
                filterByPermission = true;
                break;
            }
            case 6: {
                pattern = "; <" + REPO.HAS_READ_ACCESS + "> <" + REPO.ROLE_ANONYMOUS + ">";
                testPermission = false;
                break;
            }
            case 7: {
                pattern = "";
                if (Access.isSuperuser((HttpServletRequest)request)) break;
                throw new ForbiddenException("This view is only available to administrators.");
            }
            case 8: {
                if (!Access.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("This view is only available to administrators.");
                }
                ds.addDefaultGraph(null);
                return;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented view: " + vw);
            }
        }
        String groupString = "{ ?name <" + RDF.TYPE + "> <" + REPO.NAMED_GRAPH + "> " + pattern + " . }";
        if (filterByPermission && !Access.isSuperuser((HttpServletRequest)request)) {
            log.debug((Object)("SPARQL query pattern group to get " + vw + " graphs = " + groupString));
            Access.filterByPermission((HttpServletRequest)request, (String)"name", (String)groupString, (Access)Access.READ, (TupleQueryResultHandler)new handler("name", ds));
        } else {
            try {
                RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
                String queryString = "SELECT ?name WHERE " + groupString;
                log.debug((Object)("SPARQL query to get " + vw + " graphs =\n" + queryString));
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
                q.setIncludeInferred(true);
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.evaluate((TupleQueryResultHandler)new handler("name", ds));
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new InternalServerErrorException("Failed in query to generate view: ", (Throwable)e);
            }
        }
    }
}

