/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.BadRequestException;
import org.eaglei.repository.DataRepositoryLifecycle;
import org.eaglei.repository.Formats;
import org.eaglei.repository.NotFoundException;
import org.eaglei.repository.REPO;
import org.eaglei.repository.Utils;
import org.eaglei.repository.Views;
import org.eaglei.repository.servlet.Disseminate;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.Rio;

public class Disseminate
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Disseminate.class);
    private static final String XHTML = "http://www.w3.org/1999/xhtml";
    private static final Namespace XHTML_NS = Namespace.getNamespace((String)"http://www.w3.org/1999/xhtml");
    private static URI label1 = null;
    private static URI label2 = null;
    private static URI label3 = null;
    private static final URI RDF_1 = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#_1");
    private static final URI RDF_2 = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#_2");
    private static final URI RDF_3 = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#_3");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init(RepositoryConnection rc) throws RepositoryException {
        if (label1 == null) {
            log.debug((Object)"Initializing label1 etc URIs..");
            RepositoryResult rr = null;
            try {
                rr = rc.getStatements((Resource)REPO.LABEL_PROPERTIES, null, null, false, new Resource[0]);
                while (rr.hasNext()) {
                    Statement s = (Statement)rr.next();
                    URI p = s.getPredicate();
                    String pl = p.getLocalName();
                    if (RDF_1.equals(p)) {
                        label1 = (URI)s.getObject();
                        continue;
                    }
                    if (RDF_2.equals(p)) {
                        label2 = (URI)s.getObject();
                        continue;
                    }
                    if (!RDF_3.equals(p)) continue;
                    label3 = (URI)s.getObject();
                }
            }
            finally {
                rr.close();
            }
            if (label1 == null || label2 == null || label3 == null) {
                log.error((Object)"Missing one or more of the :LabelProperties members.  Check your repo ontology.  THIS WILL BE BAD.");
            } else {
                log.debug((Object)("Found label properties: [ " + label1 + ", " + label2 + ", " + label3 + " ]"));
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format = request.getParameter("format");
        String view = request.getParameter("view");
        String rawuri = request.getParameter("uri");
        if (rawuri == null) {
            String pi = request.getPathInfo();
            if (pi == null || pi.length() == 0) {
                throw new BadRequestException("Missing required instance URI to view.");
            }
            rawuri = DataRepositoryLifecycle.getDefaultNamespace() + pi.substring(1);
        }
        log.debug((Object)("Got request uri=" + rawuri));
        try {
            RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
            this.init(rc);
            ValueFactory vf = rc.getValueFactory();
            URI uri = null;
            try {
                uri = vf.createURI(rawuri);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Resource URI is malformed: " + rawuri);
            }
            DatasetImpl ds = new DatasetImpl();
            if (view == null) {
                Views.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (Views.View)Views.View.USER);
            } else {
                Views.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (String)view);
            }
            log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
            RepositoryResult rr = null;
            boolean goodResource = false;
            boolean exists = false;
            URI homeGraph = null;
            try {
                rr = rc.getStatements((Resource)uri, RDF.TYPE, null, false, new Resource[0]);
                while (rr.hasNext()) {
                    Statement s = (Statement)rr.next();
                    Resource ctx = s.getContext();
                    log.debug((Object)("Found statement: " + uri + " rdf:type " + s.getObject() + ", in graph " + ctx));
                    if (ctx == null || !(ctx instanceof URI) || !(view != null && view.equals("null") ? Access.hasPermission((HttpServletRequest)request, (Resource)((URI)ctx), null, (Access)Access.READ) : ds.getDefaultGraphs().contains(ctx))) continue;
                    exists = true;
                    if (!rc.hasStatement(ctx, REPO.NG_TYPE, (Value)REPO.NGTYPE_PUBLISHED, false, new Resource[0]) && !rc.hasStatement(ctx, REPO.NG_TYPE, (Value)REPO.NGTYPE_WORKSPACE, false, new Resource[0])) continue;
                    log.debug((Object)("...approving resource because of rdf:type statement in graph=" + ctx));
                    goodResource = true;
                    homeGraph = (URI)ctx;
                    break;
                }
            }
            finally {
                rr.close();
            }
            if (!exists) {
                throw new NotFoundException("Subject not found in this repository: " + uri.toString());
            }
            if (!goodResource || homeGraph == null) {
                throw new NotFoundException("Subject exists but is not available as an Eagle-I resource: " + uri.toString());
            }
            String acceptFormat = format == null ? request.getHeader("Accept") : format;
            boolean html = acceptFormat != null && acceptFormat.contains("text/html");
            StringBuilder query = new StringBuilder();
            if (html) {
                query.append("SELECT DISTINCT ?p ?pl1 ?pl2 ?pl3 ?v ?vl1 ?vl2 ?vl3 ");
            } else {
                query.append("CONSTRUCT { <").append(uri.toString()).append("> ?p ?v . ").append(" ?p <").append(label1).append("> ?pl1 .").append(" ?p <").append(label2).append("> ?pl2 .").append(" ?p <").append(label3).append("> ?pl3 .").append(" ?v <").append(label1).append("> ?vl1 .").append(" ?v <").append(label2).append("> ?vl2 .").append(" ?v <").append(label3).append("> ?vl3 }\n");
            }
            query.append("WHERE { <").append(uri.toString()).append("> ?p ?v . \n").append(" OPTIONAL { ?p <").append(label1).append("> ?pl1 } \n").append(" OPTIONAL { ?p <").append(label2).append("> ?pl2 } \n").append(" OPTIONAL { ?p <").append(label3).append("> ?pl3 } \n").append(" OPTIONAL { ?v <").append(label1).append("> ?vl1 } \n").append(" OPTIONAL { ?v <").append(label2).append("> ?vl2 } \n").append(" OPTIONAL { ?v <").append(label3).append("> ?vl3 } \n").append(" } ORDER BY ?p ?v");
            log.debug((Object)("SPARQL Query for Dissemination = " + query));
            DatasetImpl qds = null;
            if (view == null) {
                qds = new DatasetImpl();
                Views.addGraphs((HttpServletRequest)request, (DatasetImpl)qds, (Views.View)Views.View.METADATA_ONTOLOGY);
                qds.addDefaultGraph(homeGraph);
            } else {
                qds = ds;
            }
            log.debug((Object)("Home graph = " + homeGraph));
            log.debug((Object)("TEMP Dataset for result query = " + Utils.prettyPrint((Dataset)qds)));
            if (html) {
                Document result;
                Element root = new Element("html", XHTML_NS);
                Element head = new Element("head", XHTML_NS);
                root.addContent((Content)head);
                head.addContent((Content)new Element("title", XHTML_NS).addContent("Resource " + uri.toString()));
                Element body = new Element("body", XHTML_NS);
                root.addContent((Content)body);
                Element label = new Element("h2", XHTML_NS).setAttribute("class", "eaglei_resourceLabel ");
                body.addContent((Content)label);
                Element subTitle = new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceURI ").addContent("Resource " + uri.toString());
                body.addContent((Content)subTitle);
                body.addContent((Content)new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceTypes").addContent("Types"));
                Element types = new Element("ol", XHTML_NS).setAttribute("class", "eaglei_resourceTypes ");
                body.addContent((Content)types);
                body.addContent((Content)new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceProperties").addContent("Properties"));
                Element props = new Element("ol", XHTML_NS).setAttribute("class", "eaglei_resourceProperties ");
                body.addContent((Content)props);
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
                q.setIncludeInferred(true);
                q.setDataset((Dataset)qds);
                q.evaluate((TupleQueryResultHandler)new propsHandler(label, types, props));
                if (Access.hasPermission((HttpServletRequest)request, (Resource)uri, null, (Access)Access.ADMIN)) {
                    Element acl = new Element("form", XHTML_NS).setAttribute("method", "POST").setAttribute("action", "/repository/admin/editGrants.jsp");
                    acl.addContent((Content)new Element("input", XHTML_NS).setAttribute("type", "hidden").setAttribute("name", "uri").setAttribute("value", uri.toString()));
                    acl.addContent((Content)new Element("input", XHTML_NS).setAttribute("type", "hidden").setAttribute("name", "type").setAttribute("value", "Resource Instance"));
                    acl.addContent((Content)new Element("input", XHTML_NS).setAttribute("type", "hidden").setAttribute("name", "label").setAttribute("value", label.getText()));
                    acl.addContent((Content)new Element("button", XHTML_NS).setAttribute("type", "submit").addContent("Edit Access Controls"));
                    body.addContent((Content)acl);
                }
                if (!(result = new Document(root)).hasRootElement()) {
                    log.error((Object)"No root element in doc, this will be bad.");
                }
                XSLTransformer xfrm = null;
                String xslPath = DataRepositoryLifecycle.getConfigurationProperty((String)"eaglei.repository.instance.xslt");
                if (xslPath != null) {
                    File xslFile = new File(xslPath);
                    Reader xis = xslFile.isAbsolute() ? new FileReader(xslFile) : DataRepositoryLifecycle.getResourceAsReader((String)xslPath);
                    xfrm = new XSLTransformer(xis);
                    log.debug((Object)("Using XSL transformation stylesheet from: " + xslPath));
                    result = xfrm.transform(result);
                    if (!result.hasRootElement()) {
                        log.error((Object)"No root element in transformed doc, this will be bad.");
                    }
                }
                result.setDocType(new DocType("HTML", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"));
                XMLOutputter out = new XMLOutputter();
                out.setFormat(Format.getPrettyFormat());
                out.output(result, (OutputStream)response.getOutputStream());
            } else {
                String mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)format, (String)"application/rdf+xml");
                RDFFormat rf = Formats.RDFOutputFormatForMIMEType((String)mimeType);
                if (rf == null) {
                    log.error((Object)("Failed to get RDF serialization format, for mime=" + mimeType));
                    throw new ServletException("Failed to get RDF serialization format that SHOULD have been available, for mime=" + mimeType);
                }
                response.setContentType(mimeType);
                GraphQuery q = rc.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
                q.setIncludeInferred(true);
                q.setDataset((Dataset)qds);
                q.evaluate((RDFHandler)Rio.createWriter((RDFFormat)rf, (OutputStream)response.getOutputStream()));
            }
        }
        catch (XSLTransformException e) {
            log.error((Object)"Failed in XSL transformation: ", (Throwable)e);
            throw new ServletException("Failed in XSL transformation: ", (Throwable)e);
        }
        catch (MalformedQueryException e) {
            log.error((Object)"Malformed query generated internally: ", (Throwable)e);
            throw new ServletException("Malformed query generated internally: " + e.toString());
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ Namespace access$000() {
        return XHTML_NS;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

