/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.Formats;
import org.eaglei.repository.REPO;
import org.eaglei.repository.Utils;
import org.eaglei.repository.Views;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.Rio;

public class SparqlProtocol
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(SparqlProtocol.class);
    private static final String P_QUERY = "query";
    private static final String P_NAMED_GRAPH = "named-graph-uri";
    private static final String P_DEFAULT_GRAPH = "default-graph-uri";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        String rawquery = null;
        String[] namedGraph = null;
        String[] defaultGraph = null;
        String format = null;
        String rawview = null;
        Views.View view = null;
        String workspace = null;
        String time = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ArrayList<String> ngl = new ArrayList<String>();
            ArrayList<String> dgl = new ArrayList<String>();
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String s;
                    String ifn = item.getFieldName();
                    if (ifn.equals(P_QUERY)) {
                        rawquery = item.getString();
                        continue;
                    }
                    if (ifn.equals(P_DEFAULT_GRAPH)) {
                        s = item.getString();
                        if (s.length() <= 0) continue;
                        dgl.add(s);
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    if (ifn.equals(P_NAMED_GRAPH)) {
                        s = item.getString();
                        if (s.length() <= 0) continue;
                        ngl.add(s);
                        continue;
                    }
                    if (ifn.equals("view")) {
                        rawview = item.getString();
                        continue;
                    }
                    if (ifn.equals("workspace")) {
                        workspace = item.getString();
                        continue;
                    }
                    if (ifn.equals("time")) {
                        time = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                response.sendError(400, "failed parsing multipart request");
                return;
            }
            if (ngl.size() > 0) {
                namedGraph = ngl.toArray(new String[ngl.size()]);
            }
            if (dgl.size() > 0) {
                defaultGraph = dgl.toArray(new String[dgl.size()]);
            }
        } else {
            rawquery = request.getParameter(P_QUERY);
            namedGraph = request.getParameterValues(P_NAMED_GRAPH);
            if (namedGraph != null && (namedGraph.length == 0 || namedGraph[0].length() == 0)) {
                namedGraph = null;
            }
            if ((defaultGraph = request.getParameterValues(P_DEFAULT_GRAPH)) != null && (defaultGraph.length == 0 || defaultGraph[0].length() == 0)) {
                defaultGraph = null;
            }
            format = request.getParameter("format");
            rawview = request.getParameter("view");
            workspace = request.getParameter("workspace");
            time = request.getParameter("time");
        }
        if (rawquery == null || rawquery.equals("")) {
            response.sendError(400, "Missing required arg: query");
            return;
        }
        if (rawview != null && rawview.length() > 0) {
            view = Views.View.parseView((String)rawview);
        }
        if (workspace != null && workspace.length() == 0) {
            workspace = null;
        }
        int dsCount = 0;
        if (namedGraph != null || defaultGraph != null) {
            ++dsCount;
        }
        if (workspace != null) {
            ++dsCount;
        }
        if (view != null) {
            ++dsCount;
        }
        if (dsCount > 1) {
            response.sendError(400, "Only one of the arguments for 'view', 'workspace' or explicit named/default graph URIs maybe specified.");
            return;
        }
        if (dsCount == 0) {
            response.sendError(400, "Missing required argument: Exactly one of the arguments 'view', 'workspace' or explicit named/default graph URIs must be specified.");
            return;
        }
        try {
            ValueFactory vf = rc.getValueFactory();
            DatasetImpl ds = new DatasetImpl();
            if (defaultGraph != null || namedGraph != null) {
                URI gu;
                if (defaultGraph != null) {
                    for (String n : defaultGraph) {
                        gu = vf.createURI(n);
                        if (!Access.hasPermission((HttpServletRequest)request, (Resource)gu, (URI)REPO.NAMED_GRAPH, (Access)Access.READ)) {
                            response.sendError(403, "Read access denied to named graph: " + gu.toString());
                            return;
                        }
                        log.debug((Object)("Adding Default Graph to the dataset: " + n));
                        ds.addDefaultGraph(gu);
                    }
                }
                if (namedGraph != null) {
                    for (String n : namedGraph) {
                        gu = vf.createURI(n);
                        if (!Access.hasPermission((HttpServletRequest)request, (Resource)gu, (URI)REPO.NAMED_GRAPH, (Access)Access.READ)) {
                            response.sendError(403, "Read access denied to named graph: " + gu.toString());
                            return;
                        }
                        log.debug((Object)("Adding Named Graph to the dataset: " + n));
                        ds.addNamedGraph(gu);
                    }
                }
            } else if (view != null) {
                Views.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (Views.View)view);
            } else if (workspace != null) {
                response.sendError(501, "No workspaces yet");
                return;
            }
            if (ds.getDefaultGraphs().isEmpty() && ds.getNamedGraphs().isEmpty()) {
                response.sendError(500, "Empty dataset for query, this should not happen.");
                return;
            }
            Query q = rc.prepareQuery(QueryLanguage.SPARQL, rawquery);
            q.setIncludeInferred(true);
            if (Views.View.NULL.equals((Object)view)) {
                log.debug((Object)"Null view, leave query's Dataset unset!");
            } else {
                log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
                q.setDataset((Dataset)ds);
            }
            if (time != null && time.length() > 0) {
                try {
                    int tl = Integer.parseInt(time);
                    q.setMaxQueryTime(tl);
                    log.debug((Object)("Setting query time limit to " + String.valueOf(tl) + " seconds."));
                }
                catch (NumberFormatException e) {
                    response.sendError(400, "Value for 'time' must be a decimal integer; this is unacceptable: " + time);
                    return;
                }
            }
            if (q instanceof TupleQuery) {
                String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format, (String)"application/sparql-results+xml");
                TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
                if (tqf == null) {
                    log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
                    throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
                }
                response.setContentType(mimeType);
                ((TupleQuery)q).evaluate((TupleQueryResultHandler)QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream()));
            } else if (q instanceof BooleanQuery) {
                String mimeType = Formats.negotiateBooleanContent((HttpServletRequest)request, (String)format, (String)"application/sparql-results+xml");
                BooleanQueryResultFormat bf = BooleanQueryResultFormat.forMIMEType((String)mimeType);
                if (bf == null) {
                    log.error((Object)("Failed to get boolean serialization format, for mime=" + mimeType));
                    throw new ServletException("Failed to get boolean serialization format that SHOULD have been available, for mime=" + mimeType);
                }
                response.setContentType(mimeType);
                QueryResultIO.createWriter((BooleanQueryResultFormat)bf, (OutputStream)response.getOutputStream()).write(((BooleanQuery)q).evaluate());
            } else if (q instanceof GraphQuery) {
                String mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)format, (String)"application/rdf+xml");
                RDFFormat rf = Formats.RDFOutputFormatForMIMEType((String)mimeType);
                if (rf == null) {
                    log.error((Object)("Failed to get RDF serialization format, for mime=" + mimeType));
                    throw new ServletException("Failed to get RDF serialization format that SHOULD have been available, for mime=" + mimeType);
                }
                response.setContentType(mimeType);
                ((GraphQuery)q).evaluate((RDFHandler)Rio.createWriter((RDFFormat)rf, (OutputStream)response.getOutputStream()));
            } else {
                log.error((Object)"Unrecognized query type! This should never happen.");
                response.sendError(400, "Unrecognized query type! This should never happen.");
            }
        }
        catch (MalformedQueryException e) {
            log.info((Object)"Rejecting malformed query.");
            response.sendError(400, "Malformed query: " + e.toString());
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }
}

