<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   - Data Repository Admin UI: Edit Access Control (ACLs) on *any* object
   -
   - This page both presents ACLs and executes a request to edit the ACL.
   -
   -  REQUIRED ARGS:
   -   uri = uri of the object
   -  RECOMMENDED args:
   -   type = object type name to display (precision doesn't matter)
   -   label= label for the instance URI
   -   backLink, backLabel = link URL and text for "return" link
   -  ONLY REQUIRED WHEN CHANGING ACL:
   -   action= (add, remove)
   -   agent=uri of agent (user or role)
   -   access=uri of access property
   -
   -  Larry Stone  - started May 2010
  --%>
<%@ page import="javax.servlet.http.HttpServletResponse" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.openrdf.model.ValueFactory" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.Constants" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.REPO" %>
<%@ page import="org.eaglei.repository.HttpStatusException" %>

<%! private static Logger log = LogManager.getLogger("org.eaglei.repository.admin.namedGraphs.jsp"); %>

<%
    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = false;

    // sanity-check args
    String rawuri = request.getParameter("uri");
    if (rawuri == null) {
        response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'uri'");
        return;
    }
    RepositoryConnection rc = (RepositoryConnection)request.getAttribute(Constants.ATTR_CONNECTION);
    ValueFactory vf = rc.getValueFactory();
    URI uri = null;
    try {
        uri = vf.createURI(rawuri);
    } catch (IllegalArgumentException e) {
        response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI: "+e);
        return;
    }
    String type = request.getParameter("type");
    if (type == null)
        type = "Unknown-type";

    try {
        // if action given, try to do the add or remove..
        // sanity check args first:
        String action = request.getParameter("action");
        String access = request.getParameter("access");
        String agents[] = request.getParameterValues("agent");
        if (action != null) {
            String agent = null;
            for (String a : agents) {
                if (a.length() > 0) {
                    if (agent != null) {
                        response.sendError(HttpServletResponse.SC_BAD_REQUEST,
                          "There may not be more than one value for agent: "+agent+", and: "+a);
                        return;
                    } else
                        agent = a;
                }
            }
            if (agent == null || agent.length() == 0 || access == null || access.length() == 0) {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST,  "Request is missing one of the required arguments, 'agent' or 'access'.");
                return;
            }
            try {
                URI agentURI = vf.createURI(agent);
                URI accessURI = vf.createURI(access);
                if (action.equals("add")) {
                    Access.addGrant(request, uri, agentURI, accessURI);
                    messageSuccess = true;
                    message = "Successfully added new grant.";
                } else if (action.equals("remove")) {
                    messageSuccess = Access.removeGrant(request, uri, agentURI, accessURI);
                    message = messageSuccess ? "Successfully removed grant." : "Specified grant was not found.";
                } else {
                    response.sendError(HttpServletResponse.SC_BAD_REQUEST,  "Unrecognized value of 'action': "+action);
                    return;
                }
                // need to save changes to the triplestore.
                rc.commit();
            } catch (IllegalArgumentException e) {
                response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI: "+e);
                return;
            }
        }

    // This is the idiom that much of the repo code uses to pass
    // HTTP status results back as a RuntimeException subclass..
    } catch (HttpStatusException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

    // need these later
    String backLink = request.getParameter("backLink");
    if (backLink == null)
        backLink = request.getHeader("Referer");  // "sic"
    String backLabel = request.getParameter("backLabel");
%>
  <head>
    <title>Eagle-I Data Repository Admin - Edit Access Control List</title>
  </head>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Edit Access on
      <%= StringEscapeUtils.escapeHtml(type) %><% String ulabel = request.getParameter("label");
         if (ulabel != null)
            out.write(": ");
            out.write(StringEscapeUtils.escapeHtml(ulabel)); %>
    </h2>
    <h3>URI: <code>&nbsp;&nbsp;&nbsp;<%= uri.toString() %></code></h3>

<%
    if (message != null) {
%>
      <h3>Status: <font color="<%= messageSuccess ? "GREEN" : "RED" %>"><%= StringEscapeUtils.escapeHtml(message) %></font></h3>
<%
    }
%>

   <h3>Current Access Grants:</h3>
    <table border="1">
      <tr><th>Agent</th><th>Access Type</th><th>Delete</th></tr>
<%
    for (Access.Grant g : Access.getGrants(request, uri)) {
%>
      <tr>
        <td>
        <%= StringEscapeUtils.escapeHtml(g.agent.label) %>
        (<%= StringEscapeUtils.escapeHtml(g.agentType.label) %>)
        </td>
        <td><%= StringEscapeUtils.escapeHtml(g.access.label) %></td>
        <td>
<%  if (g.builtin) { %>
          <i>Built-In</i>
<%  } else { %>
          <form method="POST" action="" style="margin: 0pt;">
<%      if (backLink != null) { %>
          <input type="hidden" name="backLink" value="<%= backLink %>"/>
<%      } %>
<%  if (backLabel != null) { %>
          <input type="hidden" name="backLabel" value="<%= backLabel %>"/>
<%      } %>
          <input type="hidden" name="type" value="<%= type %>"/>
          <input type="hidden" name="uri" value="<%= uri.toString() %>"/>
          <input type="hidden" name="action" value="remove"/>
          <input type="hidden" name="agent" value="<%= g.agent.toString() %>"/>
          <input type="hidden" name="access" value="<%= g.access.toString() %>"/>
          <button type="submit">Delete!</button>
          </form>
<%  } %>
        </td>
      </tr>
<%
    }
%>
    </table>

  <h3>Add New Access Grant:</h3>

   <form method="POST" action="">
<%  if (backLink != null) { %>
    <input type="hidden" name="backLink" value="<%= backLink %>"/>
<%  } %>
<%  if (backLabel != null) { %>
    <input type="hidden" name="backLabel" value="<%= backLabel %>"/>
<%  } %>
    <input type="hidden" name="type" value="<%= type %>"/>
    <input type="hidden" name="action" value="add"/>
    <input type="hidden" name="uri" value="<%= uri.toString() %>"/>
    <table border="1">
      <tr><th>Agent</th><th>Access Type</th><th>&nbsp;</th></tr>
      <tr>
        <td>
          <font size="-1"><i>Select EITHER a user OR role:</i></font><br/>
          <b>User:</b>
          <select name="agent">
            <option value="">--none--</option>
<%
    for (User u : User.findAll(request)) {
%>
            <option value="<%= u.getURI() %>"><%= StringEscapeUtils.escapeHtml(u.getLabel()) %></option>
<%
    }
%>
          </select>
          <div align="center"><b>-- or --</b></div>
          <b>Role:</b>
          <select name="agent">
            <option value="">--none--</option>
<%
    for (Access.Term t : Access.getAllRoles(request)) {
%>
            <option value="<%= t.toString() %>"><%= StringEscapeUtils.escapeHtml(t.label) %></option>
<%
    }
%>
          </select>
        </td>
       <td>
         <select name="access">
           <option value="">--none--</option>
<%
    for (Access.Term t : Access.getAllAccesses(request)) {
%>
           <option value="<%= t.toString() %>"><%= StringEscapeUtils.escapeHtml(t.label) %></option>
<%
    }
%>
         </select>
       </td>
       <td><button type="submit">Add!</button></td>
     </tr>
    </table>
   </form>
<%
    if (backLink != null) {
        if (backLabel == null)
            backLabel = "Back to previous page";
%>
    <br/>
    <br/>
    <a href="<%= backLink %>"><%= StringEscapeUtils.escapeHtml(backLabel) %></a>
<%      } %>
    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
</html>
