package org.eaglei.search.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.eaglei.model.EIURI;

/**
 * Request for search result counts.
 */
public class SearchCountRequest implements Serializable {

    public static final long serialVersionUID = 1L;

    /*
     * The request. Search result counts are collected for this request using
     * the specified type bindings in place of the request type binding.
     */
    private SearchRequest request;
    
    /*
     * Holds the URIs of eagle-i ontology classes for which search result counts 
     * are retrieved. Each URI is used as a type binding for the associated SearchRequest
     * (i.e. URI value for the SearchRequest TypeBinding object).
     */
    // Note: if/when multiple TypeBindings are supported, count requests will only be valid
    // for a requests with a single TypeBinding
    private List<EIURI> countTypes = new ArrayList<EIURI>();

    /*
     * 
     */
    private SearchCountRequest() {
        // for gwt
    }

    /**
     * Creates a new SearchCountRequest
     * 
     * @param request The request
     */
    public SearchCountRequest(final SearchRequest request) {
        this.request = request;
    }

    /**
     * Gets the search request.
     * 
     * @return Search request.
     */
    public SearchRequest getRequest() {
        return this.request;
    }
    
    /**
     * Retrieves the URIs of ontology classes for which result counts are retrieved.
     * @return List of ontology class URIs.
     */
    public List<EIURI> getCountTypes() {
        return this.countTypes;
    }
    
    /**
     * Adds a count type.
     * @param uri URI of an ontology class for which result counts are retrieved.
     */
    public void addCountType(final EIURI uri) {
        this.countTypes.add(uri);
    }    

	@Override
	public int hashCode() {
	    return ((request == null) ? 0 : request.hashCode());
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		SearchCountRequest other = (SearchCountRequest) obj;
		if (request == null) {
			if (other.request != null) {
				return false;
			}
		} else if (!request.equals(other.request)) {
			return false;
		}
		return true;
	}
}
