package org.eaglei.search.events;

import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResult;

/**
 * Container class for change event payload items (SearchResult for now).
 * 
 * @author Rich Simon
 *
 */
public class ChangeEventPayloadItemImpl implements ChangeEventPayloadItem {
	
	private SearchResult searchResultItem;
	
	public ChangeEventPayloadItemImpl (SearchResult s) {
		searchResultItem = s;
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getDataTypeProperties()
	 */
	@Override
	public Set<EIURI> getDataTypeProperties() {
		return searchResultItem.getDataTypeProperties();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getDataTypeProperty(org.eaglei.model.EIURI)
	 */
	@Override
	public Set<String> getDataTypeProperty(EIURI eiuri) {
		return searchResultItem.getDataTypeProperty(eiuri);
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getEntity()
	 */
	@Override
	public EIEntity getEntity() {
		return searchResultItem.getEntity();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getInstitution()
	 */
	@Override
	public EIEntity getInstitution() {
		return searchResultItem.getInstitution();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getObjectProperties()
	 */
	@Override
	public Set<EIURI> getObjectProperties() {
		return searchResultItem.getObjectProperties();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getObjectProperty(org.eaglei.model.EIURI)
	 */
	@Override
	public Set<EIURI> getObjectProperty(EIURI eiuri) {
		return searchResultItem.getObjectProperty(eiuri);
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayloadItem#getType()
	 */
	@Override
	public EIEntity getType() {
		return searchResultItem.getType();
	}

}
