package org.eaglei.search.harvest;

import java.util.Date;

import org.eaglei.model.EIEntity;

/**
 * Notifications of a set resource changes.
 * The start notification indicates the beginning of a "transaction".
 * Event notifications will be fired for individual resource change information.
 * The end notification indicates the end of a set of changes.
 * Listeners should fully commit all changes received since start.
 * 
 * Note that there is no rollback support.  If one listener returns false
 * from onChangeEnd(), then all listeners may receive duplicate resouce change
 * information in a subsequent set of events.
 * 
 * @author Ted
 *
 */
public interface ResourceChangeListener {
    
	/**
	 * Indicates the start of a set of resource changes
	 * from a given institution.
	 * 
	 * @param institution
	 */
    void onChangeStreamStart(EIEntity institution);
    /**
     * Data about a single resource change.
     * Will be received between a start and an end notification.
     * 
     * @param event
     */
    void onChangeEvent(ResourceChangeEvent event);
    /**
     * Indicates the end of a set of resource change notifications.
     * All information received since start should be stored.
     * 
     * Return false if unable to process all changes received since start.
     */
    boolean onChangeStreamEnd(EIEntity institution, Date lastModifiedDate);
    /**
     * Indicates its a good time to optimize the datastore.
     * Is guaranteed to be called between event stream notifications.
     */
	void optimize();

}
