package org.eaglei.search.provider;

import java.io.IOException;

import org.eaglei.search.config.SearchConfiguration;

public class SearchResultRankMergerFactory implements SearchProviderFactory {

    public static final String NESTED_PROVIDER_FACTORY_PROP = "search.provider.merger.nested.provider.factory.class";    
    public static final String TRIM_TO_RANGE_PROP = "search.provider.merger.trim.to.range";    
    public static final String DEFAULT_TRIM_TO_RANGE_PROP = "true";
    
    @Override
    public SearchProvider createSearchProvider(SearchConfiguration config) throws IOException {
        final String nestedProviderFactoryClass = config.getProperties().getProperty(NESTED_PROVIDER_FACTORY_PROP);
        if (nestedProviderFactoryClass == null) {
            throw new IOException("Nested provider factory class property not set");
        }
        try {
            final Class factoryClass = Class.forName(nestedProviderFactoryClass);
            final MultiNodeSearchProviderFactory factory = (MultiNodeSearchProviderFactory) factoryClass.newInstance();
            final MultiNodeSearchProvider nestedProvider = factory.createMultiNodeSearchProvider(config);
            final SearchResultRankMerger merger = new SearchResultRankMerger(nestedProvider);
            final String trimToRange = config.getProperties().getProperty(TRIM_TO_RANGE_PROP, DEFAULT_TRIM_TO_RANGE_PROP);  
            merger.setTrimToRange(Boolean.parseBoolean(trimToRange));
            return merger;
        } catch (Exception e) {
            throw new IOException(e);
        }
    }

}
