/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Properties;

public class SearchConfiguration
implements Serializable {
    public static final String PROVIDER_FACTORY_CLASS = "search.provider.factory.class";
    private Properties props = new Properties();

    public SearchConfiguration(File propFile) throws IOException {
        this(new FileReader(propFile));
    }

    public SearchConfiguration(Reader propFileContents) throws IOException {
        this.props.load(propFileContents);
    }

    public String getSearchProviderFactoryClass() {
        return this.props.getProperty(PROVIDER_FACTORY_CLASS);
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getFromConfigOrSystem(String prop) {
        String value = this.props.getProperty(prop);
        if (value == null) {
            value = System.getProperty(prop);
        }
        return value;
    }
}

