package org.eaglei.search.config;

/**
 * Defines common search configuration properties
 */
public final class SearchProperties {
    
    /**
     * Name of System property that determines whether the overall search configuration: either central or institutional 
     */
    public static final String SEARCH_NODE = "org.eaglei.search.node";
    
    /**
     * Value of "search.node" System property for central search
     */
    public static final String CENTRAL = "central";
    
    /**
     * Name of System property that determines whether a test configuration is used.
     */
    public static final String SEARCH_TEST = "org.eaglei.search.test";

    /**
     * Name of System property that determines whether a central index is created.
     */
    public static final String CENTRAL_INDEX = "org.eaglei.search.central.index";
     
    /** 
     * SearchConfiguration property that holds the URL of the repository
     */
    public static final String REPOSITORY_URL = "org.eaglei.search.repository.url";
    
    /** 
     * SearchConfiguration property that holds the http basic auth username to use for calls against the repository
     */    
    public static final String REPOSITORY_USERNAME = "org.eaglei.search.repository.username";
    
    /** 
     * SearchConfiguration property that holds the http basic auth password to use for calls against the repository.
     */    
    public static final String REPOSITORY_PASSWORD = "org.eaglei.search.repository.password";   
    
    /** 
     * System property that holds a boolean value which controls
     * whether the index is updated by an indexer thread or just updated once during the init() method 
     */
    public static final String USE_INDEXER_THREAD = "org.eaglei.search.provider.lucene.composite.indexer.thread";    
    
    /** 
     * System property that holds the index update frequency in msec.
     */
    public static final String UPDATE_FREQUENCY = "org.eaglei.search.provider.lucene.composite.update.freq";           
}
