/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.request;

import com.google.gson.Gson;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.eaglei.search.common.GsonHolder;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.request.EqualityChecker;

public final class SerializationRoundTrip {
    private static final Logger log = Logger.getLogger(SerializationRoundTrip.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    private SerializationRoundTrip() {
    }

    public static final <T> void doRoundTrip(T object, Class<T> clazz) {
        SerializationRoundTrip.doRoundTrip(object, clazz, null);
    }

    public static final <T> void doRoundTrip(T object, Class<T> clazz, EqualityChecker<T> checker) {
        assert (clazz != null);
        Gson gson = GsonHolder.Gson;
        String json = gson.toJson(object);
        if (DEBUG) {
            log.debug((Object)("JSON:         " + json));
        }
        Object unmarshalled = gson.fromJson(json, clazz);
        if (DEBUG) {
            log.debug((Object)("Unmarshalled: " + gson.toJson(unmarshalled, clazz)));
        }
        if (checker != null) {
            checker.doEqualsCheck(object, unmarshalled);
        } else {
            Assert.assertEquals((String)"Should have survived round-trip to JSON and back", object, (Object)unmarshalled);
        }
    }

    public static final <T> void doRoundTrip(T object, Serializer<T> serializer) throws SerializationException {
        SerializationRoundTrip.doRoundTrip(object, serializer, null);
    }

    public static final <T> void doRoundTrip(T object, Serializer<T> serializer, EqualityChecker<T> checker) throws SerializationException {
        assert (serializer != null);
        String serialized = serializer.serialize(object);
        if (DEBUG) {
            log.debug((Object)("Serialized:   " + serialized));
        }
        Object unmarshalled = serializer.deserialize(serialized);
        if (DEBUG) {
            log.debug((Object)("Unmarshalled: " + serializer.serialize(unmarshalled)));
        }
        if (checker != null) {
            checker.doEqualsCheck(object, unmarshalled);
        } else {
            Assert.assertEquals((String)"Should have survived round-trip to JSON and back", object, (Object)unmarshalled);
        }
    }
}

