package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Map;

public class MultiDataSetSearchProvider implements SearchProvider {
    
    private Map<SearchRequest.DataSet, SearchProvider> mapDSToProvider;
    
    public MultiDataSetSearchProvider(Map<SearchRequest.DataSet, SearchProvider> mapDSToProvider) {
        this.mapDSToProvider = mapDSToProvider;
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        SearchProvider provider = mapDSToProvider.get(request.getRequest().getDataset());
        return provider.count(request);
    }

    @Override
    public void init() throws IOException {
        for (SearchProvider provider : mapDSToProvider.values()) {
            provider.init();
        }
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        SearchProvider provider = mapDSToProvider.get(request.getDataset());
        return provider.query(request);
    }

}
